/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.wb.core.editor.actions.assistant.ILayoutAssistantPage;
import org.eclipse.wb.core.editor.actions.assistant.LayoutAssistantListener;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.policy.helpers.BroadcastListenerHelper;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsoluteBasedLayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.AbstractAlignmentActionsSupport;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.ComplexAlignmentActionsSupport;
import org.eclipse.wb.internal.core.gef.policy.snapping.IAbsoluteLayoutCommands;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementsSupport;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.ui.TabFactory;
import org.eclipse.wb.internal.swt.gef.policy.layout.AbsoluteBasedLayoutEditPolicySWT;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormSelectionEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormUtils;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.LayoutAssistantPage;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class FormLayoutEditPolicy<C extends IControlInfo>
extends AbsoluteBasedLayoutEditPolicySWT<C> {
    private final IFormLayoutInfo<C> layout;

    public FormLayoutEditPolicy(IFormLayoutInfo<C> layout_) {
        super(layout_);
        this.layout = layout_;
        this.createPlacementsSupport((IAbsoluteLayoutCommands)this.layout.getImpl());
        new BroadcastListenerHelper(this.layout.getUnderlyingModel(), (EditPolicy)this, (Object)new LayoutAssistantListener(){

            public void createAssistantPages(List<ObjectInfo> objects, TabFolder folder, List<ILayoutAssistantPage> pages) throws Exception {
                if (!objects.isEmpty()) {
                    for (ObjectInfo object : objects) {
                        if (object.getParent() == FormLayoutEditPolicy.this.layout.getComposite()) continue;
                        return;
                    }
                    LayoutAssistantPage page = new LayoutAssistantPage(FormLayoutEditPolicy.this.layout, FormLayoutEditPolicy.this.placementsSupport, (Composite)folder, objects);
                    TabFactory.item((TabFolder)folder).text("FormLayout").control(page);
                    pages.add(page);
                }
            }
        });
    }

    protected void decorateChild(EditPart child) {
        if (this.layout.getControls().contains(child.getModel())) {
            child.installEditPolicy((Object)"Selection Feedback", new FormSelectionEditPolicy<C>(this.layout));
        }
    }

    @Override
    public Dimension getContainerSize() {
        return this.layout.getContainerSize();
    }

    public Point getClientAreaOffset() {
        Point offset = this.layout.getComposite().getClientArea().getLocation();
        return offset.getTranslated(FormUtils.getLayoutMarginLeft(this.layout), FormUtils.getLayoutMarginTop(this.layout));
    }

    protected void translateAbsoluteToModel(Translatable t) {
        super.translateAbsoluteToModel(t);
        t.performTranslate(this.getClientAreaOffset().getNegated());
    }

    protected void translateModelToFeedback(Translatable t) {
        super.translateModelToFeedback(t);
        t.performTranslate(this.getClientAreaOffset());
    }

    protected void eraseSelectionFeedbacks() {
        super.eraseSelectionFeedbacks();
        for (EditPart child : this.getHost().getChildren()) {
            if (!this.layout.getControls().contains(child.getModel())) continue;
            FormSelectionEditPolicy editPolicy = (FormSelectionEditPolicy)child.getEditPolicy((Object)"Selection Feedback");
            editPolicy.hideSelection();
        }
    }

    protected void showSelectionFeedbacks() {
        super.showSelectionFeedbacks();
        for (EditPart child : this.getHost().getChildren()) {
            if (!this.layout.getControls().contains(child.getModel()) || child.getSelected() == 0) continue;
            FormSelectionEditPolicy editPolicy = (FormSelectionEditPolicy)child.getEditPolicy((Object)"Selection Feedback");
            editPolicy.showSelection();
        }
    }

    protected Command getCreateCommand(final CreateRequest request) {
        return new EditCommand(this.layout){

            protected void executeEdit() throws Exception {
                FormLayoutEditPolicy.this.layout.commandCreate((IControlInfo)request.getNewObject(), null);
                FormLayoutEditPolicy.this.placementsSupport.commitAdd();
            }
        };
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        return new EditCommand(this.layout){

            protected void executeEdit() throws Exception {
                FormLayoutEditPolicy.this.placementsSupport.commit();
            }
        };
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        final List editParts = request.getEditParts();
        return new EditCommand(this.layout){

            protected void executeEdit() throws Exception {
                for (EditPart editPart : editParts) {
                    FormLayoutEditPolicy.this.layout.commandMove((IControlInfo)editPart.getModel(), null);
                }
                FormLayoutEditPolicy.this.placementsSupport.commitAdd();
            }
        };
    }

    protected void doPasteComponent(Point pasteLocation, AbsoluteBasedLayoutEditPolicy.PastedComponentInfo pastedWidget) throws Exception {
        IControlInfo control = (IControlInfo)pastedWidget.getComponent();
        this.layout.commandCreate(control, null);
    }

    protected AbstractAlignmentActionsSupport<C> getAlignmentActionsSupport() {
        return new FormLayoutAlignmentActionsSupport<C>(this.layout, this.placementsSupport);
    }

    protected ToolkitDescription getToolkit() {
        return GlobalState.getToolkit();
    }

    public static final class FormLayoutAlignmentActionsSupport<C extends IControlInfo>
    extends ComplexAlignmentActionsSupport<C> {
        private final IFormLayoutInfo<C> m_layout;

        public FormLayoutAlignmentActionsSupport(IFormLayoutInfo<C> layout, PlacementsSupport placementsSupport) {
            super(placementsSupport);
            this.m_layout = layout;
        }

        protected boolean isComponentInfo(ObjectInfo object) {
            return object instanceof IControlInfo && this.m_layout.isManagedObject(object);
        }

        protected IAbstractComponentInfo getLayoutContainer() {
            return this.m_layout.getComposite();
        }
    }
}

