/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.AssociationObjectFactories;
import org.eclipse.wb.core.model.association.AssociationObjectFactory;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidator;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidators;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.generic.FlowContainerConfigurable;
import org.eclipse.wb.internal.core.model.generic.FlowContainerConfiguration;
import org.eclipse.wb.internal.core.model.util.predicate.AlwaysPredicate;
import org.eclipse.wb.internal.core.model.util.predicate.ExpressionPredicate;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;

public final class FlowContainerFactory {
    private final JavaInfo m_javaInfo;
    private final boolean m_forCanvas;

    public FlowContainerFactory(JavaInfo javaInfo, boolean forCanvas) {
        this.m_javaInfo = javaInfo;
        this.m_forCanvas = forCanvas;
    }

    public List<FlowContainer> get() {
        ArrayList<FlowContainer> containers = new ArrayList<FlowContainer>();
        this.addConfigurableContainers(containers);
        return containers;
    }

    private void addConfigurableContainers(List<FlowContainer> containers) {
        List<FlowContainerConfiguration> configurations = this.getConfigurations();
        for (FlowContainerConfiguration configuration : configurations) {
            FlowContainerConfigurable container = new FlowContainerConfigurable(this.m_javaInfo, configuration);
            containers.add(container);
        }
    }

    public List<FlowContainerConfiguration> getConfigurations() {
        return (List)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<List<FlowContainerConfiguration>>(){

            public List<FlowContainerConfiguration> runObject() throws Exception {
                return FlowContainerFactory.this.getConfigurationsEx();
            }
        }, (String)"Exception during reading flow container configurations for %s", (Object[])new Object[]{this.m_javaInfo});
    }

    private List<FlowContainerConfiguration> getConfigurationsEx() {
        ArrayList<FlowContainerConfiguration> configurations = new ArrayList<FlowContainerConfiguration>();
        for (String prefix : this.getConfigurationPrefixes()) {
            FlowContainerConfiguration configuration = this.createConfiguration(prefix);
            configurations.add(configuration);
        }
        return configurations;
    }

    private List<String> getConfigurationPrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>();
        this.addConfigurationPrefixes(prefixes, "flowContainer");
        if (this.m_forCanvas) {
            this.addConfigurationPrefixes(prefixes, "flowContainer.canvas");
        } else {
            this.addConfigurationPrefixes(prefixes, "flowContainer.tree");
        }
        return prefixes;
    }

    private void addConfigurationPrefixes(List<String> prefixes, String basePrefix) {
        int i = 0;
        while (i < 10) {
            String prefix = basePrefix + (String)(i == 0 ? "" : "." + i);
            if ("true".equals(this.getParameter(prefix))) {
                prefixes.add(prefix);
            }
            ++i;
        }
    }

    private FlowContainerConfiguration createConfiguration(String prefix) {
        return new FlowContainerConfiguration(this.getHorizontalPredicate(prefix, true), this.getRtlPredicate(prefix, true), this.getAssociation(prefix), this.getComponentValidator(prefix), this.getReferenceValidator(prefix), this.getGroupName(prefix));
    }

    private ContainerObjectValidator getComponentValidator(String prefix) {
        String validatorExpression = this.getParameter(prefix + ".component-validator");
        if (validatorExpression != null) {
            return ContainerObjectValidators.forComponentExpression((String)validatorExpression);
        }
        String componentString = this.getComponentString(prefix);
        Assert.isNotNull((Object)componentString, (String)"No 'component' validator.");
        String[] componentTypes = StringUtils.split((String)componentString);
        return ContainerObjectValidators.forList((String[])componentTypes);
    }

    private String getComponentString(String prefix) {
        String componentString = this.getParameter(prefix + ".component");
        if (componentString == null) {
            componentString = this.getParameter("flowContainer.defaultComponent");
        }
        return componentString;
    }

    private ContainerObjectValidator getReferenceValidator(String prefix) {
        String validatorExpression = this.getParameter(prefix + ".reference-validator");
        if (validatorExpression != null) {
            return ContainerObjectValidators.forReferenceExpression((String)validatorExpression);
        }
        String referenceString = this.getReferenceString(prefix);
        Assert.isNotNull((Object)referenceString, (String)"No 'reference' validator.");
        String[] referenceTypes = StringUtils.split((String)referenceString);
        return ContainerObjectValidators.forList((String[])referenceTypes);
    }

    private String getReferenceString(String prefix) {
        String referenceString = this.getParameter(prefix + ".reference");
        if (referenceString == null) {
            referenceString = this.getParameter(prefix + ".component");
        }
        if (referenceString == null) {
            referenceString = this.getParameter("flowContainer.defaultReference");
        }
        return referenceString;
    }

    private Predicate<Object> getHorizontalPredicate(String prefix, boolean def) {
        String horizontalString = this.getParameter(prefix + ".horizontal");
        if (horizontalString == null) {
            return new AlwaysPredicate(true);
        }
        return new ExpressionPredicate(horizontalString);
    }

    private Predicate<Object> getRtlPredicate(String prefix, boolean def) {
        String rtlString = this.getParameter(prefix + ".rtl");
        if (rtlString == null) {
            return new AlwaysPredicate(false);
        }
        return new ExpressionPredicate(rtlString);
    }

    private AssociationObjectFactory getAssociation(String prefix) {
        String associationString = this.getParameter(prefix + ".association");
        if (associationString == null) {
            return AssociationObjectFactories.no();
        }
        return FlowContainerFactory.getAssociation_invocationChild(associationString);
    }

    private static AssociationObjectFactory getAssociation_invocationChild(String associationString) {
        associationString = StringUtils.removeStart((String)associationString, (String)"invocationChild ");
        Assert.isTrue((boolean)associationString.startsWith("%parent%."), (String)"Association 'invocationChild' should start with %%parent%%., but '%s' found.", (Object[])new Object[]{associationString});
        return AssociationObjectFactories.invocationChild(associationString, false);
    }

    private String getGroupName(String prefix) {
        return this.getParameter(prefix + ".group");
    }

    private String getParameter(String name) {
        return JavaInfoUtils.getParameter(this.m_javaInfo, name);
    }
}

