/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.util;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.GenericPropertySetValue;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public final class XwtStringArraySupport {
    public XwtStringArraySupport(XmlObjectInfo rootObject) {
        rootObject.addBroadcastListener((Object)new GenericPropertySetValue(){

            public void invoke(GenericPropertyImpl property, Object[] value, boolean[] shouldSetValue) throws Exception {
                GenericPropertyDescription description = property.getDescription();
                if (description.getType() == String[].class) {
                    XmlObjectInfo object = property.getObject();
                    DocumentElement element = object.getCreationSupport().getElement();
                    if (value[0] instanceof String[]) {
                        XwtStringArraySupport.this.setStringArray(object, element, description.getName(), (String[])value[0]);
                    } else if (value[0] == Property.UNKNOWN_VALUE) {
                        XwtStringArraySupport.this.removeStringArray(object, element, description.getName());
                    }
                    shouldSetValue[0] = false;
                }
            }
        });
    }

    private void setStringArray(XmlObjectInfo object, DocumentElement element, String name, String[] values) throws Exception {
        DocumentElement propertyElement = this.getPropertyElement(element, name);
        propertyElement.removeChildren();
        String itemTag = XmlObjectUtils.getTagForClass((XmlObjectInfo)object, String.class);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            DocumentElement itemElement = new DocumentElement();
            itemElement.setTag(itemTag);
            propertyElement.addChild(itemElement);
            itemElement.setText(value, false);
            ++n2;
        }
    }

    private void removeStringArray(XmlObjectInfo object, DocumentElement element, String name) throws Exception {
        DocumentElement propertyElement = this.getPropertyElement(element, name);
        if (propertyElement != null) {
            propertyElement.remove();
        }
    }

    private DocumentElement getPropertyElement(DocumentElement element, String name) {
        String propertyTag = element.getTag() + "." + name;
        DocumentElement propertyElement = element.getChild(propertyTag, true);
        if (propertyElement != null) {
            return propertyElement;
        }
        propertyElement = new DocumentElement();
        propertyElement.setTag(propertyTag);
        element.addChild(propertyElement);
        return propertyElement;
    }
}

