/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.jface;

import java.lang.reflect.Method;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectSetObjectAfter;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.xwt.model.jface.ViewerInfo;
import org.eclipse.wb.internal.xwt.parser.XwtParserBindToElement;

public class ViewerControlCreationSupport
extends CreationSupport
implements IImplicitCreationSupport {
    private final ViewerInfo m_viewer;
    private final Method m_method;
    private final String m_property;
    private DocumentElement m_element;

    public ViewerControlCreationSupport(ViewerInfo viewer, Method method, String property) {
        this.m_viewer = viewer;
        this.m_method = method;
        this.m_property = property;
        viewer.addBroadcastListener(new XmlObjectSetObjectAfter(){

            public void invoke(XmlObjectInfo target, Object o) throws Exception {
                if (target == ViewerControlCreationSupport.this.m_viewer) {
                    Object object = ViewerControlCreationSupport.this.m_method.invoke(o, new Object[0]);
                    ViewerControlCreationSupport.this.m_object.setObject(object);
                }
            }
        });
        DocumentElement viewerElement = this.m_viewer.getCreationSupport().getElement();
        String controlTag = viewerElement.getTag() + "." + this.m_property;
        this.m_element = viewerElement.getChild(controlTag, true);
    }

    public String toString() {
        if (this.m_element == null) {
            return "<" + this.getTitle() + "?>";
        }
        return ElementCreationSupport.getElementString((DocumentElement)this.m_element);
    }

    public String getTitle() {
        return this.m_viewer.getCreationSupport().getTitle() + "." + this.m_property;
    }

    public void setObject(XmlObjectInfo object) throws Exception {
        super.setObject(object);
        if (this.m_element != null) {
            ((XwtParserBindToElement)this.m_viewer.getBroadcast(XwtParserBindToElement.class)).invoke(this.m_object, this.m_element);
        }
    }

    public DocumentElement getElement() {
        if (this.m_element == null) {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    DocumentElement viewerElement = ViewerControlCreationSupport.this.m_viewer.getCreationSupport().getElement();
                    ViewerControlCreationSupport.this.m_element = new DocumentElement();
                    ViewerControlCreationSupport.this.m_element.setTag(viewerElement.getTag() + "." + ViewerControlCreationSupport.this.m_property);
                    viewerElement.addChild(ViewerControlCreationSupport.this.m_element, 0);
                }
            });
        }
        return this.m_element;
    }

    public DocumentElement getElementMove() {
        return this.m_viewer.getCreationSupport().getElementMove();
    }

    public void delete() throws Exception {
        this.m_viewer.delete();
        this.m_object.getParent().removeChild((ObjectInfo)this.m_object);
    }
}

