/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.forms;

import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectSetObjectAfter;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.xwt.parser.XwtParserBindToElement;

public class ExposedPropertyCreationSupport
extends CreationSupport
implements IImplicitCreationSupport {
    private final XmlObjectInfo m_host;
    private final String m_property;
    private final Method m_method;
    private DocumentElement m_element;

    public ExposedPropertyCreationSupport(XmlObjectInfo host, String property) {
        this.m_host = host;
        this.m_property = property;
        String signature = "get" + StringUtils.capitalize((String)property) + "()";
        this.m_method = ReflectionUtils.getMethodBySignature((Class)this.m_host.getDescription().getComponentClass(), (String)signature);
        Assert.isNotNull2((Object)this.m_method, (String)"No method {0} in {1}", (Object[])new Object[]{signature, this.m_host});
        host.addBroadcastListener((Object)new XmlObjectSetObjectAfter(){

            public void invoke(XmlObjectInfo target, Object o) throws Exception {
                if (target == ExposedPropertyCreationSupport.this.m_host) {
                    Object object = ExposedPropertyCreationSupport.this.m_method.invoke(o, new Object[0]);
                    ExposedPropertyCreationSupport.this.m_object.setObject(object);
                }
            }
        });
        DocumentElement viewerElement = this.m_host.getCreationSupport().getElement();
        if (viewerElement != null) {
            String controlTag = viewerElement.getTag() + "." + this.m_property;
            this.m_element = viewerElement.getChild(controlTag, true);
        }
    }

    public String toString() {
        if (this.m_element == null) {
            return "<" + this.getTitle() + "?>";
        }
        return ElementCreationSupport.getElementString((DocumentElement)this.m_element);
    }

    public String getTitle() {
        return this.m_host.getCreationSupport().getTitle() + "." + this.m_property;
    }

    public void setObject(XmlObjectInfo object) throws Exception {
        super.setObject(object);
        if (this.m_element != null) {
            ((XwtParserBindToElement)this.m_host.getBroadcast(XwtParserBindToElement.class)).invoke(this.m_object, this.m_element);
        }
    }

    public DocumentElement getElement() {
        if (this.m_element == null) {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    DocumentElement viewerElement = ExposedPropertyCreationSupport.this.m_host.getCreationSupport().getElement();
                    ExposedPropertyCreationSupport.this.m_element = new DocumentElement();
                    ExposedPropertyCreationSupport.this.m_element.setTag(viewerElement.getTag() + "." + ExposedPropertyCreationSupport.this.m_property);
                    viewerElement.addChild(ExposedPropertyCreationSupport.this.m_element, 0);
                }
            });
        }
        return this.m_element;
    }
}

