/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.bindings;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.parser.AbstractParser;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.VirtualBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.components.ComponentsObserveTypeContainer;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.ObjectPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;

public final class VirtualParser {
    public static Object[] getBindings(AstEditor editor, DatabindingsProvider provider, MethodDeclaration initDataBindings) throws Exception {
        ObserveInfo virtualObserve = (ObserveInfo)provider.getContainer(ObserveType.BEANS).getObservables().get(0);
        ObserveInfo virtualProperty = (ObserveInfo)virtualObserve.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable).get(0);
        PropertyInfo virtualAstProperty = virtualProperty.createProperty(virtualObserve);
        ComponentsObserveTypeContainer componentsContainer = (ComponentsObserveTypeContainer)provider.getContainer(ObserveType.WIDGETS);
        ClassLoader classLoader = EditorState.get((AstEditor)editor).getEditorLoader();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        ArrayList<VirtualBindingInfo> virtualBindings = new ArrayList<VirtualBindingInfo>();
        for (Comment comment : editor.getCommentList()) {
            String line;
            if (!(comment instanceof LineComment) || initDataBindings != editor.getEnclosingMethod(comment.getStartPosition()) || !(line = editor.getSource((ASTNode)comment)).startsWith("// [Virtual]")) continue;
            StringTokenizer tokenizer = new StringTokenizer(line);
            tokenizer.nextToken();
            tokenizer.nextToken();
            String indexValue = tokenizer.nextToken();
            int index = NumberUtils.isNumber((String)indexValue) ? Integer.parseInt(indexValue) : 0;
            boolean isSwingTarget = "target".equals(tokenizer.nextToken());
            String reference = tokenizer.nextToken();
            ObserveInfo swingObserve = componentsContainer.resolve(reference);
            if (swingObserve == null) {
                AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.VirtualParser_errUndefinedSwingObject, reference), (Throwable)new Throwable());
                continue;
            }
            ObjectPropertyInfo swingAstProperty = new ObjectPropertyInfo(swingObserve.getObjectType());
            ObserveInfo swingProperty = ((PropertyInfo)swingAstProperty).getObserveProperty(swingObserve);
            String elementClassName = tokenizer.nextToken();
            ClassGenericType elementType = null;
            try {
                elementType = new ClassGenericType(CoreUtils.load((ClassLoader)classLoader, (String)elementClassName), null, null);
            }
            catch (ClassNotFoundException e) {
                AbstractParser.addError((AstEditor)editor, (String)MessageFormat.format(Messages.VirtualParser_errUnknownElementClass, elementClassName), (Throwable)new Throwable());
                continue;
            }
            VirtualBindingInfo binding = null;
            binding = isSwingTarget ? new VirtualBindingInfo(swingObserve, swingProperty, swingAstProperty, virtualObserve, virtualProperty, virtualAstProperty) : new VirtualBindingInfo(virtualObserve, virtualProperty, virtualAstProperty, swingObserve, swingProperty, swingAstProperty);
            binding.setElementType(elementType);
            indexes.add(index);
            virtualBindings.add(binding);
            binding.create(provider.getRootInfo().getBindings());
        }
        return new Object[]{indexes, virtualBindings};
    }
}

