/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.properties;

import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfoVisitor;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.ElPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.BeanPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;

public final class ElPropertyInfo
extends PropertyInfo {
    private final PropertyInfo m_baseProperty;
    private String m_expression;

    public ElPropertyInfo(IGenericType sourceObjectType, IGenericType valueType, PropertyInfo baseProperty, String expression) {
        super(sourceObjectType, valueType);
        this.m_baseProperty = baseProperty;
        this.setExpression(expression);
    }

    public String getExpression() {
        return StringEscapeUtils.unescapeJava((String)this.m_expression);
    }

    public void setExpression(String expression) {
        Assert.isNotNull((Object)expression);
        this.m_expression = StringUtilities.escapeJava((String)expression);
    }

    public PropertyInfo getBaseProperty() {
        return this.m_baseProperty;
    }

    @Override
    public ObserveInfo getObserveProperty(ObserveInfo observeObject) throws Exception {
        if (this.m_baseProperty != null) {
            Assert.instanceOf(BeanPropertyInfo.class, (Object)((Object)this.m_baseProperty));
            observeObject = this.m_baseProperty.getObserveProperty(observeObject);
        }
        for (IObserveInfo observeProperty : observeObject.getChildren(IObserveInfo.ChildrenContext.ChildrenForPropertiesTable)) {
            if (!(observeProperty instanceof ElPropertyObserveInfo)) continue;
            return (ObserveInfo)observeProperty;
        }
        return null;
    }

    public void addSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        if (this.getVariableIdentifier() == null) {
            this.setVariableIdentifier(generationSupport.generateLocalName(new String[]{this.m_sourceObjectType.getSimpleTypeName(), "EvalutionProperty"}));
        }
        Object base = "";
        if (this.m_baseProperty != null) {
            generationSupport.addSourceCode((AstObjectInfo)this.m_baseProperty, lines);
            base = this.m_baseProperty.getVariableIdentifier() + ", ";
        }
        if (generationSupport.useGenerics()) {
            lines.add("org.jdesktop.beansbinding.ELProperty" + GenericUtils.getTypesSource(this.m_sourceObjectType, this.m_valueType) + " " + this.getVariableIdentifier() + " = org.jdesktop.beansbinding.ELProperty.create(" + (String)base + "\"" + this.m_expression + "\");");
        } else {
            lines.add("org.jdesktop.beansbinding.Property " + this.getVariableIdentifier() + " = org.jdesktop.beansbinding.ELProperty.create(" + (String)base + "\"" + this.m_expression + "\");");
        }
    }

    public void accept(AstObjectInfoVisitor visitor) throws Exception {
        super.accept(visitor);
        if (this.m_baseProperty != null) {
            this.m_baseProperty.accept(visitor);
        }
    }

    @Override
    public String getPresentationText(IObserveInfo observeObject, IObserveInfo observeProperty, boolean full) throws Exception {
        if (full && this.m_expression.length() > 0) {
            Object basePresentationText = "";
            if (this.m_baseProperty != null) {
                basePresentationText = this.m_baseProperty.getPresentationText(null, null, true) + ".";
            }
            return observeObject.getPresentation().getTextForBinding() + ".[" + (String)basePresentationText + this.m_expression + "]";
        }
        return super.getPresentationText(observeObject, observeProperty, full);
    }
}

