/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.menu;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;

public final class MenuSelectionEditPolicy
extends SelectionEditPolicy {
    private Figure m_selectionFigure;
    private AncestorListener m_ancestorListener;

    @Override
    protected List<Handle> createSelectionHandles() {
        return Collections.emptyList();
    }

    @Override
    protected void showSelection() {
        this.hideSelection();
        this.m_selectionFigure = new Figure();
        this.m_selectionFigure.setBorder(new LineBorder(IColorConstants.menuBackgroundSelected));
        this.updateFeedbackBounds();
        this.m_ancestorListener = new AncestorListener.Stub(){

            public void ancestorMoved(IFigure ancestor) {
                MenuSelectionEditPolicy.this.updateFeedbackBounds();
            }
        };
        this.getHostFigure().addAncestorListener(this.m_ancestorListener);
        this.addFeedback(this.m_selectionFigure);
    }

    @Override
    protected void hideSelection() {
        if (this.m_selectionFigure != null) {
            this.getHostFigure().removeAncestorListener(this.m_ancestorListener);
            this.removeFeedback(this.m_selectionFigure);
            this.m_selectionFigure = null;
        }
    }

    @Override
    protected Layer getFeedbackLayer() {
        return this.getLayer("Menu Feedback Layer");
    }

    private void updateFeedbackBounds() {
        Rectangle selectionBounds = this.getHostFigure().getBounds().getCopy();
        FigureUtils.translateFigureToFigure(this.getHostFigure(), this.m_selectionFigure, (Translatable)selectionBounds);
        this.m_selectionFigure.setBounds(selectionBounds);
    }
}

