/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette.dialogs;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.dialogfields.BooleanDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogFieldUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.StringAreaDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.StringButtonDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.StringDialogField;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.xml.Messages;
import org.eclipse.wb.internal.core.xml.editor.palette.dialogs.AbstractPaletteElementDialog;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescriptionHelper;

public abstract class ComponentAbstractDialog
extends AbstractPaletteElementDialog {
    private final EditorContext m_context;
    private ComponentDescription m_componentDescription;
    protected StringDialogField m_idField;
    protected StringDialogField m_nameField;
    protected StringButtonDialogField m_classField;
    protected StringAreaDialogField m_descriptionField;
    protected BooleanDialogField m_visibleField;
    private Composite m_fieldsContainer;

    public ComponentAbstractDialog(Shell parentShell, EditorContext context, String shellText, String titleText) {
        super(parentShell, shellText, titleText, null, Messages.ComponentAbstractDialog_message);
        this.m_context = context;
    }

    protected void createControls(Composite container) {
        this.m_fieldsContainer = container;
        GridLayoutFactory.create((Composite)container).columns(3);
        this.m_idField = new StringDialogField();
        this.m_idField.setEditable(false);
        this.doCreateField((DialogField)this.m_idField, Messages.ComponentAbstractDialog_idLabel);
        this.m_nameField = new StringDialogField();
        this.doCreateField((DialogField)this.m_nameField, Messages.ComponentAbstractDialog_nameLabel);
        this.m_nameField.setFocus();
        this.m_classField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                try {
                    String componentClassName = JdtUiUtils.selectTypeName((Shell)ComponentAbstractDialog.this.getShell(), (IJavaProject)ComponentAbstractDialog.this.m_context.getJavaProject());
                    if (componentClassName != null) {
                        ComponentAbstractDialog.this.m_classField.setText(componentClassName);
                        ComponentAbstractDialog.this.prepareComponentDescription();
                        ComponentAbstractDialog.this.m_nameField.setText(CodeUtils.getShortClass((String)componentClassName));
                        if (ComponentAbstractDialog.this.m_componentDescription != null) {
                            ComponentAbstractDialog.this.m_descriptionField.setText(ComponentAbstractDialog.this.m_componentDescription.getDescription());
                        } else {
                            ComponentAbstractDialog.this.m_descriptionField.setText(componentClassName);
                        }
                    }
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
        });
        this.m_classField.setButtonLabel(Messages.ComponentAbstractDialog_classChoose);
        this.doCreateField((DialogField)this.m_classField, Messages.ComponentAbstractDialog_classLabel);
        this.m_classField.getTextControl(null).setEditable(false);
        this.m_descriptionField = new StringAreaDialogField(5);
        this.doCreateField((DialogField)this.m_descriptionField, Messages.ComponentAbstractDialog_descriptionLabel);
        GridDataFactory.modify((Control)this.m_descriptionField.getTextControl(null)).grabV();
        this.m_visibleField = new BooleanDialogField();
        this.doCreateField((DialogField)this.m_visibleField, Messages.ComponentAbstractDialog_visibleLabel);
    }

    @Override
    protected void okPressed() {
        this.prepareComponentDescription();
        super.okPressed();
    }

    protected final String validate() {
        String className = this.m_classField.getText().trim();
        if (className.length() == 0) {
            return Messages.ComponentAbstractDialog_validationEmptyClass;
        }
        try {
            this.m_context.getClassLoader().loadClass(className);
        }
        catch (Throwable e) {
            return e.getClass().getName() + ": " + e.getMessage();
        }
        String name = this.m_nameField.getText().trim();
        if (name.length() == 0) {
            return Messages.ComponentAbstractDialog_validationEmptyName;
        }
        return null;
    }

    protected final void doCreateField(DialogField dialogField, String labelText) {
        dialogField.setLabelText(labelText);
        dialogField.setDialogFieldListener(this.m_validateListener);
        DialogFieldUtils.fillControls((Composite)this.m_fieldsContainer, (DialogField)dialogField, (int)3, (int)60);
    }

    private void prepareComponentDescription() {
        this.m_componentDescription = null;
        try {
            String componentClassName = this.m_classField.getText();
            this.m_componentDescription = ComponentDescriptionHelper.getDescription(this.m_context, componentClassName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String getDescriptionText() {
        boolean isSameAsMetadata;
        String text = this.m_descriptionField.getText();
        boolean isEmpty = StringUtils.isEmpty((String)text);
        boolean isClassName = this.m_classField.getText().equals(text);
        boolean bl = isSameAsMetadata = this.m_componentDescription != null && text.equals(this.m_componentDescription.getDescription());
        if (isEmpty || isClassName || isSameAsMetadata) {
            text = null;
        }
        return text;
    }
}

