/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef.util.EditPartUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Display;

public class MarqueeSelectionTool
extends AbstractTool {
    public static final int BEHAVIOR_CONNECTIONS_CONTAINED = 6;
    public static final int BEHAVIOR_CONNECTIONS_TOUCHED = 2;
    public static final int BEHAVIOR_NODES_CONTAINED = 1;
    public static final int BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS = 3;
    public static final int BEHAVIOR_NODES_TOUCHED = 4;
    public static final int BEHAVIOR_NODES_TOUCHED_AND_RELATED_CONNECTIONS = 5;
    public static final int BEHAVIOR_NODES_AND_CONNECTIONS = 3;
    static final int DEFAULT_MODE = 0;
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private static final Request MARQUEE_REQUEST = new Request("selection");
    public static final Object PROPERTY_MARQUEE_BEHAVIOR = "marqueeBehavior";
    public static final int DEFAULT_MARQUEE_BEHAVIOR = 1;
    private Set allChildren = new HashSet();
    private int marqueeBehavior = 1;
    private IFigure marqueeRectangleFigure;
    private int mode;
    private Collection selectedEditParts;
    private Request targetRequest;

    public MarqueeSelectionTool() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    @Override
    protected void applyProperty(Object key, Object value) {
        if (PROPERTY_MARQUEE_BEHAVIOR.equals(key)) {
            if (value instanceof Integer) {
                this.setMarqueeBehavior((Integer)value);
            }
            return;
        }
        super.applyProperty(key, value);
    }

    protected Collection calculateMarqueeSelectedEditParts() {
        HashSet marqueeSelectedEditParts = new HashSet();
        marqueeSelectedEditParts.addAll(this.calculatePrimaryMarqueeSelectedEditParts());
        marqueeSelectedEditParts.addAll(this.calculateSecondaryMarqueeSelectedEditParts(marqueeSelectedEditParts));
        return marqueeSelectedEditParts;
    }

    private Collection calculatePrimaryMarqueeSelectedEditParts() {
        HashSet<? extends GraphicalEditPart> editPartsToProcess = new HashSet<GraphicalEditPart>();
        if (this.marqueeBehavior != 6 && this.marqueeBehavior != 2) {
            editPartsToProcess.addAll(EditPartUtilities.getAllChildren((GraphicalEditPart)((Object)this.getCurrentViewer().getRootEditPart())));
        }
        if (this.marqueeBehavior != 1 && this.marqueeBehavior != 4) {
            editPartsToProcess.addAll(EditPartUtilities.getAllNestedConnectionEditParts((GraphicalEditPart)((Object)this.getCurrentViewer().getRootEditPart())));
        }
        ArrayList<GraphicalEditPart> marqueeSelectedEditParts = new ArrayList<GraphicalEditPart>();
        for (GraphicalEditPart graphicalEditPart : editPartsToProcess) {
            if (!this.isMarqueeSelectable(graphicalEditPart) || !this.isPrimaryMarqueeSelectedEditPart(graphicalEditPart)) continue;
            marqueeSelectedEditParts.add(graphicalEditPart);
        }
        return marqueeSelectedEditParts;
    }

    private Collection calculateSecondaryMarqueeSelectedEditParts(Collection directlyMarqueeSelectedEditParts) {
        HashSet editPartsToProcess = new HashSet();
        for (GraphicalEditPart marqueeSelectedEditPart : directlyMarqueeSelectedEditParts) {
            editPartsToProcess.addAll(marqueeSelectedEditPart.getSourceConnections());
            editPartsToProcess.addAll(marqueeSelectedEditPart.getTargetConnections());
        }
        HashSet<GraphicalEditPart> secondaryMarqueeSelectedEditParts = new HashSet<GraphicalEditPart>();
        for (GraphicalEditPart editPart : editPartsToProcess) {
            if (!this.isSecondaryMarqueeSelectedEditPart(directlyMarqueeSelectedEditParts, editPart)) continue;
            secondaryMarqueeSelectedEditParts.add(editPart);
        }
        return secondaryMarqueeSelectedEditParts;
    }

    private Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    @Override
    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.allChildren.clear();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback(this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        for (EditPart editPart : this.selectedEditParts) {
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    @Override
    protected String getCommandName() {
        return "selection";
    }

    protected Rectangle getCurrentMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    protected int getCurrentSelectionMode() {
        return this.mode;
    }

    @Override
    protected String getDebugName() {
        return "Marquee Tool: " + this.marqueeBehavior;
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = this.createMarqueeRectangleFigure();
            this.addFeedback(this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    protected IFigure createMarqueeRectangleFigure() {
        return new MarqueeRectangleFigure();
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    @Override
    protected boolean handleButtonDown(int button) {
        if (!this.isCurrentViewerGraphical()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            } else {
                this.setSelectionMode(0);
            }
        }
        return true;
    }

    @Override
    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    @Override
    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = this.calculateMarqueeSelectedEditParts();
            this.showTargetFeedback();
        }
        return true;
    }

    @Override
    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    @Override
    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        if (this.getCurrentViewer().getKeyHandler() != null) {
            return this.getCurrentViewer().getKeyHandler().keyPressed(e);
        }
        return false;
    }

    protected boolean isMarqueeSelectable(GraphicalEditPart editPart) {
        return editPart.getTargetEditPart(MARQUEE_REQUEST) == editPart && editPart.isSelectable() && FigureUtilities.isNotFullyClipped((IFigure)editPart.getFigure());
    }

    private boolean isPrimaryMarqueeSelectedEditPart(GraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        Rectangle r = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)r);
        boolean included = false;
        Rectangle marqueeSelectionRectangle = this.getCurrentMarqueeSelectionRectangle();
        if (editPart instanceof ConnectionEditPart) {
            if ((this.marqueeBehavior == 2 || this.marqueeBehavior == 6) && marqueeSelectionRectangle.intersects(r)) {
                Rectangle relMarqueeRect = Rectangle.SINGLETON;
                figure.translateToRelative((Translatable)relMarqueeRect.setBounds(marqueeSelectionRectangle));
                if (this.marqueeBehavior == 2) {
                    included = ((Connection)figure).getPoints().intersects(relMarqueeRect);
                } else if (this.marqueeBehavior == 6) {
                    included = relMarqueeRect.contains(((Connection)figure).getPoints().getBounds());
                }
            }
        } else if (this.marqueeBehavior == 4 || this.marqueeBehavior == 5) {
            included = marqueeSelectionRectangle.intersects(r);
        } else if (this.marqueeBehavior == 1 || this.marqueeBehavior == 3) {
            included = marqueeSelectionRectangle.contains(r);
        }
        return included;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSecondaryMarqueeSelectedEditPart(Collection directlyMarqueeSelectedEditParts, EditPart editPart) {
        boolean included = false;
        EditPart editPart2 = editPart;
        if (editPart2 instanceof ConnectionEditPart) {
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart2;
            ConnectionEditPart cfr_ignored_0 = (ConnectionEditPart)editPart2;
            if (this.marqueeBehavior == 3 || this.marqueeBehavior == 5) {
                void connection;
                GraphicalEditPart source = (GraphicalEditPart)connection.getSource();
                GraphicalEditPart target = (GraphicalEditPart)connection.getTarget();
                boolean sourceIncludedInMarqueeSelection = directlyMarqueeSelectedEditParts.contains(source);
                boolean targetIncludedInMarqueeSelection = directlyMarqueeSelectedEditParts.contains(target);
                if (this.mode == 0) {
                    included = sourceIncludedInMarqueeSelection && targetIncludedInMarqueeSelection;
                } else if (this.mode == 2) {
                    included = !(connection.getSelected() != 0 || !this.getCurrentViewer().getSelectedEditParts().contains(source) && !sourceIncludedInMarqueeSelection || !this.getCurrentViewer().getSelectedEditParts().contains(target) && !targetIncludedInMarqueeSelection);
                } else if (this.mode == 1) {
                    included = connection.getSelected() == 0 ? (source.getSelected() == 0 && sourceIncludedInMarqueeSelection || source.getSelected() != 0 && !sourceIncludedInMarqueeSelection) && (target.getSelected() == 0 && targetIncludedInMarqueeSelection || target.getSelected() != 0 && !targetIncludedInMarqueeSelection) : source.getSelected() != 0 && sourceIncludedInMarqueeSelection || target.getSelected() != 0 && targetIncludedInMarqueeSelection;
                }
            }
        }
        return included;
    }

    @Override
    protected boolean isViewerImportant(EditPartViewer viewer) {
        return this.isCurrentViewerGraphical();
    }

    private boolean isCurrentViewerGraphical() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    protected void performMarqueeSelect() {
        Collection marqueeSelectedEditParts = this.calculateMarqueeSelectedEditParts();
        LinkedHashSet<? extends EditPart> editPartsToSelect = new LinkedHashSet<EditPart>();
        HashSet<EditPart> editPartsToDeselect = new HashSet<EditPart>();
        for (EditPart affectedEditPart : marqueeSelectedEditParts) {
            if (affectedEditPart.getSelected() == 0 || this.getCurrentSelectionMode() != 1) {
                editPartsToSelect.add(affectedEditPart);
                continue;
            }
            editPartsToDeselect.add(affectedEditPart);
        }
        if (this.getCurrentSelectionMode() != 0) {
            editPartsToSelect.addAll(this.getCurrentViewer().getSelectedEditParts());
            editPartsToSelect.removeAll(editPartsToDeselect);
        }
        this.getCurrentViewer().setSelection((ISelection)new StructuredSelection(editPartsToSelect.toArray()));
    }

    public void setMarqueeBehavior(int type) {
        if (type != 2 && type != 6 && type != 4 && type != 5 && type != 1 && type != 3) {
            throw new IllegalArgumentException("Invalid marquee behaviour specified.");
        }
        this.marqueeBehavior = type;
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(Cursors.CROSS);
        } else {
            this.setDefaultCursor(Cursors.NO);
        }
    }

    private void showMarqueeFeedback() {
        Rectangle rect = this.getCurrentMarqueeSelectionRectangle().getCopy();
        IFigure marqueeFeedbackFigure = this.getMarqueeFeedbackFigure();
        marqueeFeedbackFigure.translateToRelative((Translatable)rect);
        marqueeFeedbackFigure.setBounds(rect);
        marqueeFeedbackFigure.validate();
    }

    private void showTargetFeedback() {
        for (EditPart editPart : this.selectedEditParts) {
            editPart.showTargetFeedback(this.getTargetRequest());
        }
    }

    private static class MarqueeRectangleFigure
    extends Figure {
        private static final int DELAY = 110;
        private int offset = 0;
        private boolean schedulePaint = true;

        private MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setLineStyle(3);
            int[] points = new int[]{0 + this.offset, 0, bounds.width - 1, 0, bounds.width - 1, bounds.height - 1};
            graphics.drawPolyline(points);
            points[0] = 0;
            points[1] = 0 + this.offset;
            points[2] = 0;
            points[3] = bounds.height - 1;
            points[4] = bounds.width - 1;
            points[5] = bounds.height - 1;
            graphics.drawPolyline(points);
            graphics.translate(this.getLocation().getNegated());
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(){

                    @Override
                    public void run() {
                        ++offset;
                        if (offset > 5) {
                            offset = 0;
                        }
                        schedulePaint = true;
                        this.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }
    }
}

