/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.gef.part;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.gef.policy.selection.LineSelectionEditPolicy;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.requests.SelectionRequest;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.xwt.model.jface.ViewerInfo;

public class ViewerEditPart
extends GraphicalEditPart {
    private final ViewerInfo m_viewer;

    public ViewerEditPart(ViewerInfo viewer) {
        this.setModel((Object)viewer);
        this.m_viewer = viewer;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new LineSelectionEditPolicy(IColorConstants.black){

            protected Rectangle getHostBounds() {
                Rectangle bounds = ViewerEditPart.this.getIconBounds();
                bounds.performTranslate(this.getHostFigure().getLocation());
                return bounds;
            }
        });
    }

    protected Figure createFigure() {
        return new Figure(){

            protected void paintClientArea(Graphics graphics) {
                ImageDescriptor imageDescriptor = ViewerEditPart.this.m_viewer.getDescription().getIcon();
                if (imageDescriptor != null) {
                    Image image = imageDescriptor.createImage();
                    Rectangle iconBounds = ViewerEditPart.this.getIconBounds();
                    graphics.drawImage(image, iconBounds.x, iconBounds.y);
                    image.dispose();
                }
            }
        };
    }

    protected void refreshVisuals() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                Rectangle bounds = ((GraphicalEditPart)ViewerEditPart.this.getParent()).getFigure().getClientArea();
                ViewerEditPart.this.getFigure().setBounds(bounds);
            }
        });
    }

    private Rectangle getIconBounds() {
        ImageData imageData = this.m_viewer.getDescription().getIcon().getImageData(100);
        int width = imageData.width;
        int height = imageData.height;
        Point location = this.getFigure().getBounds().getBottomRight().getTranslated(-width, -height);
        location.performTranslate(-3, -3);
        return new Rectangle(location.x, location.y, width, height);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof SelectionRequest) {
            SelectionRequest selectionRequest = (SelectionRequest)request;
            Point location = selectionRequest.getLocation();
            if (location == null) {
                return this;
            }
            location = location.getCopy();
            FigureUtils.translateAbsoluteToFigure2((Figure)this.getFigure(), (Translatable)location);
            if (!this.getIconBounds().contains(location)) {
                return this.getParent().getTargetEditPart(request);
            }
        }
        return super.getTargetEditPart(request);
    }

    protected List<?> getModelChildren() {
        return (List)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<List<?>>(){

            public List<?> runObject() throws Exception {
                return ViewerEditPart.this.m_viewer.getPresentation().getChildrenGraphical();
            }
        }, Collections.emptyList());
    }
}

