/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.core;

import org.eclipse.draw2d.EventListenerList;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.ICommandExceptionHandler;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.internal.gef.core.CancelOperationError;
import org.eclipse.wb.internal.gef.core.IActiveToolListener;
import org.eclipse.wb.internal.gef.core.IDefaultToolProvider;

public class EditDomain {
    private Tool m_activeTool;
    private Tool m_defaultTool;
    private IEditPartViewer m_currentViewer;
    private MouseEvent m_currentMouseEvent;
    private ICommandExceptionHandler m_exceptionHandler;
    private Tool m_inCommandTool;
    private IDefaultToolProvider m_defaultToolProvider;
    private final EventListenerList m_eventTable = new EventListenerList();

    public EditDomain() {
        this.loadDefaultTool();
    }

    public void executeCommand(Command command) {
        this.clearToolDuringCommandExecution();
        try {
            try {
                if (System.getProperty("wbp.EditDomain.simulateCommandException") != null) {
                    throw new Error("Simulated exception.");
                }
                command.execute();
            }
            catch (Throwable e) {
                if (this.m_exceptionHandler != null) {
                    this.m_exceptionHandler.handleException(e);
                    throw new CancelOperationError();
                }
                this.restoreToolAfterCommandExecution();
            }
        }
        finally {
            this.restoreToolAfterCommandExecution();
        }
    }

    private void clearToolDuringCommandExecution() {
        if (this.m_activeTool != null) {
            this.m_inCommandTool = this.m_activeTool;
            this.m_activeTool = null;
        }
    }

    private void restoreToolAfterCommandExecution() {
        if (this.m_activeTool == null) {
            this.m_activeTool = this.m_inCommandTool;
        }
    }

    public void setExceptionHandler(ICommandExceptionHandler exceptionHandler) {
        this.m_exceptionHandler = exceptionHandler;
    }

    public void setDefaultToolProvider(IDefaultToolProvider toolListener) {
        this.m_defaultToolProvider = toolListener;
    }

    public void addActiveToolListener(IActiveToolListener listener) {
        this.m_eventTable.addListener(IActiveToolListener.class, (Object)listener);
    }

    public void removeActiveToolListener(IActiveToolListener listener) {
        this.m_eventTable.removeListener(IActiveToolListener.class, (Object)listener);
    }

    public void loadDefaultTool() {
        if (this.m_defaultToolProvider != null) {
            this.m_defaultToolProvider.loadDefaultTool();
        } else {
            this.setActiveTool(this.getDefaultTool());
        }
    }

    public Tool getDefaultTool() {
        if (this.m_defaultTool == null) {
            this.m_defaultTool = new SelectionTool();
        }
        return this.m_defaultTool;
    }

    public void setDefaultTool(Tool defaultTool) {
        this.m_defaultTool = defaultTool;
    }

    public Tool getActiveTool() {
        return this.m_activeTool;
    }

    public void setActiveTool(Tool activeTool) {
        if (this.m_activeTool != null) {
            this.m_activeTool.deactivate();
        }
        this.m_activeTool = activeTool;
        if (this.m_activeTool != null) {
            this.m_activeTool.setDomain(this);
            this.m_activeTool.activate();
            for (IActiveToolListener listener : this.m_eventTable.getListenersIterable(IActiveToolListener.class)) {
                listener.toolActivated(this.m_activeTool);
            }
            if (this.m_currentViewer != null) {
                this.m_activeTool.setViewer(this.m_currentViewer);
                this.m_activeTool.refreshCursor();
                this.m_activeTool.mouseMove(this.m_currentMouseEvent, this.m_currentViewer);
            }
        }
    }

    public void keyPressed(KeyEvent event, IEditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.keyPressed(event, viewer);
        }
    }

    public void keyReleased(KeyEvent event, IEditPartViewer viewer) {
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.keyReleased(event, viewer);
        }
    }

    public void mouseDoubleClick(MouseEvent event, IEditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseDoubleClick(event, viewer);
        }
    }

    public void mouseDown(MouseEvent event, IEditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseDown(event, viewer);
        }
    }

    public void mouseUp(MouseEvent event, IEditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseUp(event, viewer);
        }
    }

    public void mouseMove(MouseEvent event, IEditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseMove(event, viewer);
        }
    }

    public void mouseDrag(MouseEvent event, IEditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.mouseDrag(event, viewer);
        }
    }

    public void viewerEntered(MouseEvent event, IEditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        this.m_currentViewer = viewer;
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.viewerEntered(event, viewer);
        }
    }

    public void viewerExited(MouseEvent event, IEditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        this.m_currentViewer = null;
        Tool tool = this.getActiveTool();
        if (tool != null) {
            tool.viewerExited(event, viewer);
        }
    }
}

