/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.Figure;

public class Polyline
extends Figure {
    private boolean m_xorMode;
    private int m_lineStyle = 1;
    private int m_lineWidth = 1;
    private PointList m_points = new PointList();
    private Rectangle m_pointsBounds;
    private static final Rectangle TEMP_BOUNDS = new Rectangle();

    public void addPoint(Point point) {
        this.m_points.addPoint(point);
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    public void insertPoint(Point point, int index) {
        this.m_points.insertPoint(point, index);
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    public void removePoint(int index) {
        this.m_points.removePoint(index);
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    public void removeAllPoints() {
        this.m_points.removeAllPoints();
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    public PointList getPoints() {
        return this.m_points;
    }

    public void setPoints(PointList points) {
        this.m_points = points;
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    public Point getStart() {
        return this.m_points.getFirstPoint();
    }

    public void setStart(Point point) {
        if (this.m_points.size() == 0) {
            this.addPoint(point);
        } else {
            this.setPoint(point, 0);
        }
    }

    public void setEnd(Point point) {
        int size = this.m_points.size();
        if (size < 2) {
            this.addPoint(point);
        } else {
            this.setPoint(point, size - 1);
        }
    }

    public Point getEnd() {
        return this.m_points.getLastPoint();
    }

    public void setEndpoints(Point start, Point end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void setPoint(Point point, int index) {
        this.m_points.setPoint(point, index);
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = super.getBounds();
        if (this.m_pointsBounds != this.m_points.getBounds()) {
            this.m_pointsBounds = this.m_points.getBounds();
            bounds.setBounds(this.m_pointsBounds);
            bounds.expand(this.m_lineWidth / 2, this.m_lineWidth / 2);
        }
        return bounds;
    }

    @Override
    public void setBounds(Rectangle bounds) {
    }

    @Override
    public boolean containsPoint(int x, int y) {
        TEMP_BOUNDS.setBounds(this.getBounds());
        int tolerance = this.m_lineWidth / 2 + 2;
        TEMP_BOUNDS.expand(tolerance, tolerance);
        if (!TEMP_BOUNDS.contains(x, y)) {
            return false;
        }
        int[] points = this.m_points.toIntArray();
        int index = 0;
        while (index < points.length - 3) {
            if (Polyline.lineContainsPoint(points[index], points[index + 1], points[index + 2], points[index + 3], x, y, tolerance)) {
                return true;
            }
            index += 2;
        }
        return false;
    }

    private static final boolean lineContainsPoint(int x1, int y1, int x2, int y2, int px, int py, int tolerance) {
        TEMP_BOUNDS.setBounds(x1, y1, 0, 0);
        TEMP_BOUNDS.union(x2, y2);
        TEMP_BOUNDS.expand(tolerance, tolerance);
        if (!TEMP_BOUNDS.contains(px, py)) {
            return false;
        }
        int result = 0;
        if (x1 != x2 && y1 != y2) {
            int v1x = x2 - x1;
            int v1y = y2 - y1;
            int v2x = px - x1;
            int v2y = py - y1;
            int numerator = v2x * v1y - v1x * v2y;
            int denominator = v1x * v1x + v1y * v1y;
            result = (int)((long)numerator * (long)numerator / (long)denominator);
        }
        return result <= tolerance * tolerance;
    }

    public void setOpaque(boolean opaque) {
    }

    @Override
    protected void paintClientArea(Graphics graphics) {
        Rectangle bounds = super.getBounds();
        graphics.translate(-bounds.x, -bounds.y);
        graphics.setXORMode(this.m_xorMode);
        graphics.setLineStyle(this.m_lineStyle);
        graphics.setLineWidth(this.m_lineWidth);
        graphics.drawPolyline(this.m_points);
    }

    public int getLineStyle() {
        return this.m_lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        if (this.m_lineStyle != lineStyle) {
            this.m_lineStyle = lineStyle;
            this.repaint();
        }
    }

    public int getLineWidth() {
        return this.m_lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        if (this.m_lineWidth != lineWidth) {
            this.m_lineWidth = lineWidth;
            this.m_pointsBounds = null;
            if (this.isVisible()) {
                this.revalidate();
                this.repaint();
            }
        }
    }

    public boolean isXorMode() {
        return this.m_xorMode;
    }

    public void setXorMode(boolean xorMode) {
        if (this.m_xorMode != xorMode) {
            this.m_xorMode = xorMode;
            this.repaint();
        }
    }
}

