/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.helpers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ComponentPresentation;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.EditorStateLoadingContext;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.description.resource.ResourceInfo;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.ImageUtils;
import org.eclipse.wb.internal.core.utils.xml.parser.QAttribute;
import org.eclipse.wb.internal.core.utils.xml.parser.QHandler;
import org.eclipse.wb.internal.core.utils.xml.parser.QHandlerAdapter;
import org.eclipse.wb.internal.core.utils.xml.parser.QParser;
import org.osgi.framework.Bundle;

public final class ComponentPresentationHelper {
    public static final String PALETTE_PRELOAD_JOBS = "palette pre-load";
    private static final Map<String, ComponentPresentationCache> m_presentationCaches = Maps.newTreeMap();

    private ComponentPresentationHelper() {
    }

    public static ComponentPresentation getPresentation(AstEditor editor, String componentClassName, String creationId) throws Exception {
        String key = ComponentPresentationHelper.getKey(componentClassName, creationId);
        ComponentPresentation presentation = null;
        ComponentPresentationCache cache = ComponentPresentationHelper.getCache(editor);
        presentation = cache.get(key);
        if (presentation != null) {
            return presentation;
        }
        ClassLoader classLoader = EditorState.get(editor).getEditorLoader();
        Class<?> componentClass = classLoader.loadClass(componentClassName);
        presentation = ComponentPresentationHelper.getFastPresentation(editor, componentClass, creationId);
        if (presentation != null) {
            return presentation;
        }
        return ComponentPresentationHelper.getSlowPresentation(editor, componentClass, key);
    }

    private static ComponentPresentation getFastPresentation(AstEditor editor, Class<?> componentClass, String creationId) throws Exception {
        EditorState state = EditorState.get(editor);
        ILoadingContext context = EditorStateLoadingContext.get(state);
        String componentClassName = componentClass.getName();
        ResourceInfo resource = DescriptionHelper.getComponentDescriptionResource(context, componentClass);
        if (resource != null) {
            ComponentParseHelper parseHelper = ComponentPresentationHelper.parseResource(resource.getURL());
            String desc = parseHelper.getDescription(creationId);
            String name = parseHelper.getName(componentClassName, creationId);
            String key = ComponentPresentationHelper.getKey(componentClassName, creationId);
            String toolkitId = ComponentPresentationHelper.getToolkitId(state, resource);
            ImageDescriptor icon = ComponentPresentationHelper.getComponentImageDescriptor(componentClass, creationId, context);
            ComponentPresentation presentation = new ComponentPresentation(key, toolkitId, name, desc, icon);
            if (ComponentPresentationHelper.shouldCacheFast(resource.getBundle())) {
                ComponentPresentationCache cache = ComponentPresentationHelper.getCache(editor);
                cache.put(presentation);
            }
            return presentation;
        }
        return null;
    }

    private static String getToolkitId(EditorState state, ResourceInfo resource) {
        ToolkitDescription toolkit = resource.getToolkit();
        return toolkit == null ? state.getToolkitId() : toolkit.getId();
    }

    private static boolean shouldCacheFast(Bundle bundle) {
        if (bundle != null) {
            return bundle.getEntry("wbp-meta/.wbp-cache-presentations") != null;
        }
        return false;
    }

    private static ImageDescriptor getComponentImageDescriptor(Class<?> clazz, String creationId, ILoadingContext context) throws Exception {
        String iconPath = ComponentPresentationHelper.getImageName(clazz.getName(), creationId);
        ImageDescriptor image = DescriptionHelper.getIcon(context, iconPath);
        if (image == null) {
            return ComponentPresentationHelper.getComponentImageDescriptor(clazz.getSuperclass(), null, context);
        }
        return image;
    }

    private static byte[] getComponentImage(Bundle bundle, String componentClassName, String creationId) throws Exception {
        String iconPath = "/wbp-meta/" + ComponentPresentationHelper.getImageName(componentClassName, creationId);
        String[] stringArray = DescriptionHelper.ICON_EXTS;
        int n = DescriptionHelper.ICON_EXTS.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            String iconName = String.valueOf(iconPath) + ext;
            URL entry = bundle.getEntry(iconName);
            if (entry != null) {
                InputStream stream = entry.openStream();
                return IOUtils2.readBytes((InputStream)stream);
            }
            ++n2;
        }
        return null;
    }

    private static String getImageName(String componentClassName, String creationId) {
        String imageName = componentClassName.replace('.', '/');
        return creationId == null ? imageName : String.valueOf(imageName) + "_" + creationId;
    }

    private static ComponentPresentation getSlowPresentation(AstEditor editor, Class<?> componentClass, String requiredKey) throws Exception {
        ComponentPresentation presentationForKey = null;
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription(editor, componentClass);
        for (CreationDescription creationDescription : componentDescription.getCreations()) {
            ComponentPresentation presentation = ComponentPresentationHelper.createPresentation(componentDescription, creationDescription);
            if (componentDescription.isPresentationCached()) {
                ComponentPresentationCache cache = ComponentPresentationHelper.getCache(editor);
                cache.put(presentation);
            }
            if (!requiredKey.equals(presentation.getKey())) continue;
            presentationForKey = presentation;
        }
        return presentationForKey;
    }

    private static ComponentPresentation createPresentation(ComponentDescription componentDescription, CreationDescription creationDescription) {
        String componentKey = componentDescription.getComponentClass().getName();
        String key = String.valueOf(componentKey) + " " + creationDescription.getId();
        String toolkitId = componentDescription.getToolkit().getId();
        String name = creationDescription.getName();
        String description = creationDescription.getDescription();
        ImageDescriptor icon = creationDescription.getIcon();
        return new ComponentPresentation(key, toolkitId, name, description, icon);
    }

    private static ComponentParseHelper parseResource(URL url) throws Exception {
        String xml = IOUtils2.readString((InputStream)url.openStream());
        ComponentParseHelper parseHelper = new ComponentParseHelper(xml);
        QParser.parse((Reader)new StringReader(xml), (QHandler)parseHelper);
        return parseHelper;
    }

    private static String getKey(String componentClassName, String creationId) {
        return String.valueOf(componentClassName) + " " + creationId;
    }

    private static ComponentPresentationCache getCache(AstEditor editor) throws Exception {
        String toolkitId = EditorState.get(editor).getToolkitId();
        return ComponentPresentationHelper.getCache(toolkitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ComponentPresentationCache getCache(String toolkitId) throws Exception {
        Map<String, ComponentPresentationCache> map = m_presentationCaches;
        synchronized (map) {
            ComponentPresentationCache cache = m_presentationCaches.get(toolkitId);
            if (cache == null) {
                cache = new ComponentPresentationCache(toolkitId);
                m_presentationCaches.put(toolkitId, cache);
                cache.load();
            }
            return cache;
        }
    }

    public static void scheduleFillingPresentationCache(final String toolkitId) {
        Job job = new Job("Updating WindowBuilder palette..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ComponentPresentationCache cache = ComponentPresentationHelper.getCache(toolkitId);
                    if (monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    ComponentPresentationHelper.fillPresentations(cache, toolkitId, monitor);
                }
                catch (Exception e) {
                    DesignerPlugin.log((Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return ComponentPresentationHelper.PALETTE_PRELOAD_JOBS.equals(family);
            }
        };
        job.schedule();
    }

    private static void fillPresentations(ComponentPresentationCache cache, String toolkitId, IProgressMonitor monitor) throws Exception {
        HashMap bundles = Maps.newHashMap();
        for (IConfigurationElement iConfigurationElement : DescriptionHelper.getToolkitElements(toolkitId)) {
            IConfigurationElement[] elements = iConfigurationElement.getChildren("palette");
            ArrayList paletteElements = Lists.newArrayList();
            Collections.addAll(paletteElements, elements);
            bundles.put(ExternalFactoriesHelper.getExtensionBundle((IConfigurationElement)iConfigurationElement), paletteElements);
        }
        for (Map.Entry entry : bundles.entrySet()) {
            Bundle bundle = (Bundle)entry.getKey();
            for (IConfigurationElement paletteElement : (List)entry.getValue()) {
                IConfigurationElement[] iConfigurationElementArray = paletteElement.getChildren("category");
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement categoryElement = iConfigurationElementArray[n2];
                    IConfigurationElement[] iConfigurationElementArray2 = categoryElement.getChildren();
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray2[n4];
                        if ("component".equals(element.getName())) {
                            String className = ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"class");
                            String creationId = element.getAttribute("creationId");
                            if (monitor.isCanceled()) {
                                return;
                            }
                            ComponentPresentationHelper.fetchLightPresentation(bundle, cache, toolkitId, className, creationId);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    private static void fetchLightPresentation(Bundle bundle, ComponentPresentationCache cache, String toolkitId, String componentClassName, String creationId) throws Exception {
        if (cache.get(ComponentPresentationHelper.getKey(componentClassName, creationId)) != null) {
            return;
        }
        String resourceName = "/wbp-meta/" + componentClassName.replace('.', '/') + ".wbp-component.xml";
        URL resourceEntry = bundle.getEntry(resourceName);
        if (resourceEntry != null) {
            ComponentParseHelper parseHelper = ComponentPresentationHelper.parseResource(resourceEntry);
            String desc = parseHelper.getDescription(creationId);
            String name = parseHelper.getName(componentClassName, creationId);
            String key = ComponentPresentationHelper.getKey(componentClassName, creationId);
            byte[] iconBytes = ComponentPresentationHelper.getComponentImage(bundle, componentClassName, creationId);
            if (iconBytes == null) {
                return;
            }
            ComponentPresentation presentation = new ComponentPresentation(key, toolkitId, name, desc, iconBytes);
            cache.put(presentation);
        }
    }

    private static final class ComponentParseHelper
    extends QHandlerAdapter {
        private String m_currentId = null;
        private final Map<String, String> m_descriptions = Maps.newHashMap();
        private final Map<String, String> m_names = Maps.newHashMap();
        private final String m_xml;
        private int m_descStart;

        public ComponentParseHelper(String xml) {
            this.m_xml = xml;
        }

        public void startElement(int offset, int length, String name, Map<String, String> attributes, List<QAttribute> attrList, boolean closed) throws Exception {
            if ("description".equals(name)) {
                this.m_descStart = offset + length;
            }
            if ("creation".equals(name)) {
                String id;
                this.m_currentId = id = attributes.get("id");
                String compName = attributes.get("name");
                this.m_names.put(id, compName);
            }
        }

        public void endElement(int offset, int endOffset, String name) throws Exception {
            if ("description".equals(name)) {
                this.m_descriptions.put(this.m_currentId, this.m_xml.substring(this.m_descStart, offset));
            }
        }

        public String getDescription(String creationId) {
            String desc = this.m_descriptions.get(creationId);
            if (desc == null) {
                return "";
            }
            return desc;
        }

        public String getName(String className, String creationId) {
            String name = this.m_names.get(creationId);
            if (name == null) {
                name = CodeUtils.getShortClass(className);
            }
            return name;
        }
    }

    private static class ComponentPresentationCache {
        private final String m_toolkitId;
        private final List<Bundle> m_bundles = Lists.newArrayList();
        private final Set<String> m_bundleCheckSums = Sets.newHashSet();
        private final File m_cacheFile;
        private final Map<String, ComponentPresentation> m_presentations = Maps.newTreeMap();

        public ComponentPresentationCache(String toolkitId) throws Exception {
            this.m_toolkitId = toolkitId;
            this.m_cacheFile = this.getCacheFile();
        }

        public ComponentPresentation get(String key) {
            return this.m_presentations.get(key);
        }

        public void put(ComponentPresentation presentation) throws Exception {
            this.m_presentations.put(presentation.getKey(), presentation);
            this.writeCacheEntry(presentation);
        }

        public void load() {
            try {
                this.prepareBundles();
                this.prepareBundleCheckSums();
                this.ensureCacheExistsAndNotStale();
                this.loadFromCacheFile();
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
                try {
                    this.m_cacheFile.delete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void loadFromCacheFile() throws Exception {
            FileInputStream stream = new FileInputStream(this.m_cacheFile);
            try {
                this.loadFromStream(stream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }

        private void loadFromStream(InputStream inputStream) throws Exception {
            inputStream = new BufferedInputStream(inputStream);
            DataInputStream dataInput = new DataInputStream(inputStream);
            ComponentPresentationCache.readCheckSums(dataInput);
            try {
                while (true) {
                    String key = dataInput.readUTF();
                    String toolkitId = dataInput.readUTF();
                    String name = dataInput.readUTF();
                    String description = dataInput.readUTF();
                    int bytesLength = dataInput.readInt();
                    byte[] iconBytes = new byte[bytesLength];
                    dataInput.readFully(iconBytes);
                    ComponentPresentation presentation = new ComponentPresentation(key, toolkitId, name, description, iconBytes);
                    this.m_presentations.put(key, presentation);
                }
            }
            catch (EOFException eOFException) {
                return;
            }
        }

        private void writeCacheEntry(ComponentPresentation presentation) throws Exception {
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.m_cacheFile, "rw");){
                randomAccessFile.seek(randomAccessFile.length());
                randomAccessFile.writeUTF(presentation.getKey());
                randomAccessFile.writeUTF(presentation.getToolkitId());
                randomAccessFile.writeUTF(presentation.getName());
                randomAccessFile.writeUTF(presentation.getDescription());
                byte[] bytes = ImageUtils.getBytesPNG((ImageDescriptor)presentation.getIcon());
                randomAccessFile.writeInt(bytes.length);
                randomAccessFile.write(bytes);
            }
        }

        private void prepareBundles() {
            for (IConfigurationElement toolkitElement : DescriptionHelper.getToolkitElements(this.m_toolkitId)) {
                Bundle bundle = ExternalFactoriesHelper.getExtensionBundle((IConfigurationElement)toolkitElement);
                this.m_bundles.add(bundle);
            }
        }

        private void prepareBundleCheckSums() throws Exception {
            for (Bundle bundle : this.m_bundles) {
                URL presentationsResource = bundle.getEntry("wbp-meta/.wbp-cache-presentations");
                if (presentationsResource == null) continue;
                String checkSum = IOUtils2.readString((InputStream)presentationsResource.openStream());
                this.m_bundleCheckSums.add(checkSum);
            }
        }

        private File getCacheFile() throws Exception {
            File stateDirectory = DesignerPlugin.getDefault().getStateLocation().toFile();
            File descriptionsDirectory = new File(stateDirectory, "descriptions");
            File cacheFile = new File(descriptionsDirectory, String.valueOf(this.m_toolkitId) + ".cached-presentations.dat");
            Files.createParentDirs((File)cacheFile);
            return cacheFile;
        }

        private boolean cacheExistsAndNotStale() {
            try {
                Set<String> cacheCheckSums;
                if (this.m_cacheFile.exists() && this.m_bundleCheckSums.equals(cacheCheckSums = this.getCacheCheckSums())) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        private void ensureCacheExistsAndNotStale() throws Exception {
            if (!this.cacheExistsAndNotStale()) {
                try {
                    this.m_cacheFile.delete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!this.m_cacheFile.exists()) {
                this.createNewCacheFile();
            }
        }

        private void createNewCacheFile() throws Exception {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.m_cacheFile));
            DataOutputStream dataOutput = new DataOutputStream(outputStream);
            try {
                dataOutput.writeInt(this.m_bundleCheckSums.size());
                for (String checkSum : this.m_bundleCheckSums) {
                    dataOutput.writeUTF(checkSum);
                }
            }
            finally {
                IOUtils.closeQuietly((OutputStream)dataOutput);
            }
        }

        private Set<String> getCacheCheckSums() throws Exception {
            InputStream inputStream = new FileInputStream(this.m_cacheFile);
            try {
                inputStream = new BufferedInputStream(inputStream);
                DataInputStream dataInput = new DataInputStream(inputStream);
                Set<String> set = ComponentPresentationCache.readCheckSums(dataInput);
                return set;
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }

        private static Set<String> readCheckSums(DataInputStream dataInput) throws IOException {
            HashSet checkSums = Sets.newHashSet();
            int sumCount = dataInput.readInt();
            int i = 0;
            while (i < sumCount) {
                String checkSum = dataInput.readUTF();
                checkSums.add(checkSum);
                ++i;
            }
            return checkSums;
        }
    }
}

