/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.editor.actions.CopyAction;
import org.eclipse.wb.internal.core.editor.actions.CutAction;
import org.eclipse.wb.internal.core.editor.actions.DeleteAction;
import org.eclipse.wb.internal.core.editor.actions.PasteAction;
import org.eclipse.wb.internal.core.editor.actions.RefreshAction;
import org.eclipse.wb.internal.core.editor.actions.TestAction;
import org.eclipse.wb.internal.core.editor.actions.assistant.LayoutAssistantAction;
import org.eclipse.wb.internal.core.editor.actions.errors.ErrorsAction;

public final class DesignPageActions {
    private final IEditPartViewer m_viewer;
    private final IActionBars m_actionBars;
    private final IAction m_cutAction;
    private final IAction m_copyAction;
    private final IAction m_pasteAction;
    private final IAction m_deleteAction;
    private final TestAction m_testAction;
    private final IAction m_refreshAction;
    private final ErrorsAction m_errorsAction;
    private final LayoutAssistantAction m_assistantAction;
    private final Map<String, IAction> m_originalActions = Maps.newTreeMap();

    public DesignPageActions(IEditorPart editor, IEditPartViewer viewer) {
        this.m_viewer = viewer;
        this.m_actionBars = editor.getEditorSite().getActionBars();
        this.m_errorsAction = new ErrorsAction();
        this.m_cutAction = new CutAction(this.m_viewer);
        this.m_copyAction = new CopyAction(this.m_viewer);
        this.m_pasteAction = new PasteAction(this.m_viewer);
        this.m_deleteAction = new DeleteAction(this.m_viewer);
        this.m_testAction = new TestAction();
        this.m_refreshAction = new RefreshAction();
        this.m_assistantAction = new LayoutAssistantAction(editor, viewer);
    }

    public void setRoot(JavaInfo root) {
        this.m_testAction.setRoot(root);
        this.m_assistantAction.setRoot((ObjectInfo)root);
    }

    public ErrorsAction getErrorsAction() {
        return this.m_errorsAction;
    }

    public IAction getCutAction() {
        return this.m_cutAction;
    }

    public IAction getCopyAction() {
        return this.m_copyAction;
    }

    public IAction getPasteAction() {
        return this.m_pasteAction;
    }

    public IAction getDeleteAction() {
        return this.m_deleteAction;
    }

    public IAction getTestAction() {
        return this.m_testAction;
    }

    public IAction getRefreshAction() {
        return this.m_refreshAction;
    }

    public LayoutAssistantAction getAssistantAction() {
        return this.m_assistantAction;
    }

    /*
     * WARNING - void declaration
     */
    public IAction getAction(String actionID) {
        try {
            Field[] fieldArray = this.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Object fieldObject = field.get(this);
                Object object = fieldObject;
                if (object instanceof IAction) {
                    void action;
                    IAction cfr_ignored_0 = (IAction)object;
                    IAction cfr_ignored_1 = (IAction)object;
                    if (actionID.equals(action.getId())) {
                        return action;
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void installActions() {
        this.m_assistantAction.showWindow();
        this.installAction(this.m_cutAction);
        this.installAction(this.m_copyAction);
        this.installAction(this.m_pasteAction);
        this.installAction(this.m_deleteAction);
        this.installAction(this.m_refreshAction);
        this.installEmptyAction(ActionFactory.SELECT_ALL.getId());
        this.m_actionBars.updateActionBars();
    }

    private void installAction(IAction action) {
        String id = action.getId();
        IAction oldAction = this.m_actionBars.getGlobalActionHandler(id);
        if (!this.m_originalActions.containsKey(id)) {
            this.m_originalActions.put(id, oldAction);
            this.m_actionBars.setGlobalActionHandler(id, action);
        }
    }

    private void installEmptyAction(String id) {
        IAction oldAction = this.m_actionBars.getGlobalActionHandler(id);
        if (!this.m_originalActions.containsKey(id)) {
            this.m_originalActions.put(id, oldAction);
            this.m_actionBars.setGlobalActionHandler(id, null);
        }
    }

    public void uninstallActions() {
        this.m_assistantAction.hideWindow();
        for (Map.Entry<String, IAction> entry : this.m_originalActions.entrySet()) {
            String id = entry.getKey();
            IAction action = entry.getValue();
            this.m_actionBars.setGlobalActionHandler(id, action);
        }
        this.m_originalActions.clear();
        this.m_actionBars.updateActionBars();
    }

    public void dispose() {
        this.m_assistantAction.closeWindow();
    }
}

