/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.ui.preferences;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wildwebdeveloper.ui.preferences.Settings;

public abstract class ProcessStreamConnectionProviderWithPreference
extends ProcessStreamConnectionProvider
implements IPropertyChangeListener {
    private static final Map<PreferenceStoreKey, PropertyChangeListenerWrapper> listenerPerLanguageServer = new HashMap<PreferenceStoreKey, PropertyChangeListenerWrapper>();
    private final PreferenceStoreKey preferenceStoreKey;
    private final String[] supportedSections;
    private LanguageServersRegistry.LanguageServerDefinition languageServerDefinition;

    public ProcessStreamConnectionProviderWithPreference(String languageServerId, IPreferenceStore preferenceStore, String[] supportedSections) {
        this.preferenceStoreKey = new PreferenceStoreKey(preferenceStore, languageServerId);
        this.supportedSections = supportedSections;
    }

    public void start() throws IOException {
        super.start();
        this.addPropertyChangeListenerIfNeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertyChangeListenerIfNeed() {
        Map<PreferenceStoreKey, PropertyChangeListenerWrapper> map = listenerPerLanguageServer;
        synchronized (map) {
            PropertyChangeListenerWrapper listener = listenerPerLanguageServer.get(this.preferenceStoreKey);
            if (listener == null) {
                listener = new PropertyChangeListenerWrapper(this);
                listenerPerLanguageServer.put(this.preferenceStoreKey, listener);
            }
            if (listener.hasNoServerStarted()) {
                this.preferenceStoreKey.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)listener);
            }
            listener.startServer();
        }
    }

    public void stop() {
        this.removePropertyChangeListenerIfNeed();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePropertyChangeListenerIfNeed() {
        Map<PreferenceStoreKey, PropertyChangeListenerWrapper> map = listenerPerLanguageServer;
        synchronized (map) {
            PropertyChangeListenerWrapper listener = listenerPerLanguageServer.get(this.preferenceStoreKey);
            if (listener != null) {
                listener.endServer();
                if (listener.hasNoServerStarted()) {
                    this.preferenceStoreKey.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)listener);
                    listenerPerLanguageServer.remove(this.preferenceStoreKey);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isAffected(event)) {
            LanguageServersRegistry.LanguageServerDefinition languageServerDefinition = this.getLanguageServerDefinition();
            DidChangeConfigurationParams params = new DidChangeConfigurationParams(this.createSettings());
            ConcurrentHashMap.KeySetView notifiedServers = ConcurrentHashMap.newKeySet();
            ((LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject(null).withPreferredServer(languageServerDefinition)).excludeInactive().collectAll((wrapper, server) -> {
                if (languageServerDefinition.equals(wrapper.serverDefinition) && notifiedServers.add(server)) {
                    server.getWorkspaceService().didChangeConfiguration(params);
                }
                return CompletableFuture.completedFuture(null);
            });
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen()) {
                    ((LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject((IProject)project).withPreferredServer(languageServerDefinition)).excludeInactive().collectAll((wrapper, server) -> {
                        if (languageServerDefinition.equals(wrapper.serverDefinition) && notifiedServers.add(server)) {
                            server.getWorkspaceService().didChangeConfiguration(params);
                        }
                        return CompletableFuture.completedFuture(null);
                    });
                }
                ++n2;
            }
            iProjectArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            n = iProjectArray.length;
            n2 = 0;
            while (n2 < n) {
                IProject win = iProjectArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = win.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n5 = iEditorReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IDocument doc;
                        IEditorReference ref = iEditorReferenceArray[n6];
                        IEditorPart editor = ref.getEditor(false);
                        if (editor != null && (doc = LSPEclipseUtils.getDocument((IEditorInput)editor.getEditorInput())) != null) {
                            ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)doc).withPreferredServer(languageServerDefinition)).collectAll((wrapper, server) -> {
                                if (languageServerDefinition.equals(wrapper.serverDefinition) && notifiedServers.add(server)) {
                                    server.getWorkspaceService().didChangeConfiguration(params);
                                }
                                return CompletableFuture.completedFuture(null);
                            });
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private LanguageServersRegistry.LanguageServerDefinition getLanguageServerDefinition() {
        if (this.languageServerDefinition == null) {
            this.languageServerDefinition = LanguageServersRegistry.getInstance().getDefinition(this.preferenceStoreKey.languageServerId);
        }
        return this.languageServerDefinition;
    }

    protected boolean isAffected(PropertyChangeEvent event) {
        String property = event.getProperty();
        String[] stringArray = this.supportedSections;
        int n = this.supportedSections.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedSection = stringArray[n2];
            if (Settings.isMatchSection(property, supportedSection)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected abstract Object createSettings();

    private static class PreferenceStoreKey {
        public final IPreferenceStore preferenceStore;
        public final String languageServerId;

        public PreferenceStoreKey(IPreferenceStore preferenceStore, String languageServerId) {
            this.preferenceStore = preferenceStore;
            this.languageServerId = languageServerId;
        }

        public int hashCode() {
            return Objects.hash(this.languageServerId, this.preferenceStore);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PreferenceStoreKey other = (PreferenceStoreKey)obj;
            return Objects.equals(this.languageServerId, other.languageServerId) && Objects.equals(this.preferenceStore, other.preferenceStore);
        }
    }

    private static class PropertyChangeListenerWrapper
    implements IPropertyChangeListener {
        private final IPropertyChangeListener listener;
        private int languageServerStartedNumber;

        public PropertyChangeListenerWrapper(IPropertyChangeListener listener) {
            this.listener = listener;
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.listener.propertyChange(event);
        }

        public boolean hasNoServerStarted() {
            return this.languageServerStartedNumber == 0;
        }

        public void startServer() {
            ++this.languageServerStartedNumber;
        }

        public void endServer() {
            --this.languageServerStartedNumber;
        }
    }
}

