/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.Properties;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wildwebdeveloper.embedder.node.Activator;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.osgi.framework.Bundle;

@ExtendWith(value={AllCleanRule.class})
public class TestNodeJsEmbedder {
    @Test
    public void testNodeJsEmbedder() throws Exception {
        URL nodeJsInfo = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("nodejs-info.properties"));
        Assertions.assertNotNull((Object)nodeJsInfo, (String)"NodeJs descriptor \"nodejs-info.properties\" not found!");
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream infoStream = nodeJsInfo.openStream();){
            properties.load(infoStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertTrue((properties.getProperty("archiveURL") != null && !properties.getProperty("archiveURL").isEmpty() ? 1 : 0) != 0, (String)"Property \"archiveURL\" is not defined");
        Assertions.assertTrue((properties.getProperty("archiveFile") != null && !properties.getProperty("archiveFile").isEmpty() ? 1 : 0) != 0, (String)"Property \"archiveFile\" is not defined");
        Assertions.assertTrue((properties.getProperty("nodePath") != null && !properties.getProperty("nodePath").isEmpty() ? 1 : 0) != 0, (String)"Property \"nodePath\" is not defined");
        File nodePath = NodeJSManager.getNodeJsLocation();
        Assertions.assertNotNull((Object)nodePath, (String)"Node.Js location cannot be found");
        Assertions.assertTrue((nodePath.exists() && nodePath.canRead() && nodePath.canExecute() ? 1 : 0) != 0, (String)"Embedded NodeJs is not extracted");
        TestNodeJsEmbedder.assertNodeInstalledInOneOfLocations(nodePath, TestNodeJsEmbedder.getOrderedInstallationLocations(), properties.getProperty("nodePath"));
    }

    @Test
    public void testNodeJsEmbedderWhich() throws Exception {
        URL nodeJsInfo = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("nodejs-info.properties"));
        Assertions.assertNotNull((Object)nodeJsInfo, (String)"NodeJs descriptor \"nodejs-info.properties\" not found!");
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream infoStream = nodeJsInfo.openStream();){
            properties.load(infoStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertTrue((properties.getProperty("archiveURL") != null && !properties.getProperty("archiveURL").isEmpty() ? 1 : 0) != 0, (String)"Property \"archiveURL\" is not defined");
        Assertions.assertTrue((properties.getProperty("archiveFile") != null && !properties.getProperty("archiveFile").isEmpty() ? 1 : 0) != 0, (String)"Property \"archiveFile\" is not defined");
        Assertions.assertTrue((properties.getProperty("nodePath") != null && !properties.getProperty("nodePath").isEmpty() ? 1 : 0) != 0, (String)"Property \"nodePath\" is not defined");
        File embeddedNodePath = NodeJSManager.getNodeJsLocation();
        Assertions.assertNotNull((Object)embeddedNodePath, (String)"Node.Js location cannot be found");
        Assertions.assertTrue((embeddedNodePath.exists() && embeddedNodePath.canRead() && embeddedNodePath.canExecute() ? 1 : 0) != 0, (String)"Embedded NodeJs is not extracted");
        TestNodeJsEmbedder.assertNodeInstalledInOneOfLocations(embeddedNodePath, TestNodeJsEmbedder.getOrderedInstallationLocations(), properties.getProperty("nodePath"));
        File whichNode = NodeJSManager.which((String)"node");
        Assertions.assertTrue((whichNode.exists() && whichNode.canRead() && whichNode.canExecute() && embeddedNodePath.getParent().equals(whichNode.getParent()) ? 1 : 0) != 0, (String)"NodeJSManager.which(\"node\") didn't return an embedded NodeJs");
        File whichNpm = NodeJSManager.which((String)"npm");
        Assertions.assertTrue((whichNpm.exists() && whichNpm.canRead() && whichNpm.canExecute() && embeddedNodePath.getParent().equals(whichNpm.getParent()) ? 1 : 0) != 0, (String)"NodeJSManager.which(\"npm\") didn't return an embedded NodeJs's NPM");
        File whichNpx = NodeJSManager.which((String)"npx");
        Assertions.assertTrue((whichNpx.exists() && whichNpx.canRead() && whichNpx.canExecute() && embeddedNodePath.getParent().equals(whichNpx.getParent()) ? 1 : 0) != 0, (String)"NodeJSManager.which(\"npx\") didn't return an embedded NodeJs\\'s NPX");
    }

    @Test
    public void testNPMSeemsCorrect() {
        File npm = NodeJSManager.getNpmLocation();
        Assertions.assertTrue((boolean)npm.isFile());
        Assertions.assertTrue((npm.length() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue(("win32".equals(Platform.getOS()) || Files.isSymbolicLink(npm.toPath()) ? 1 : 0) != 0);
    }

    private static final File[] getOrderedInstallationLocations() {
        Location installLocation = Platform.getInstallLocation();
        File installLocationFile = installLocation != null && installLocation.getURL() != null ? new File(installLocation.getURL().getFile(), ".node") : null;
        Location userLocation = Platform.getUserLocation();
        File userLocationFile = userLocation != null && userLocation.getURL() != null ? new File(userLocation.getURL().getFile(), ".node") : null;
        IPath stateLocationPath = InternalPlatform.getDefault().getStateLocation(Platform.getBundle((String)"org.eclipse.wildwebdeveloper.embedder.node"));
        Assertions.assertNotNull((Object)stateLocationPath, (String)"State location cannot be found for plugin \"org.eclipse.wildwebdeveloper.embedder.node\"");
        File stateLocationFile = stateLocationPath.toFile();
        return new File[]{installLocationFile, userLocationFile, stateLocationFile};
    }

    private static void assertNodeInstalledInOneOfLocations(@NonNull File nodePath, File[] locations, String nodeRelativePath) {
        File[] fileArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            File embeddedNodePath;
            File location = fileArray[n2];
            if (location != null && nodePath.equals(embeddedNodePath = new File(location, nodeRelativePath))) {
                return;
            }
            ++n2;
        }
        Assertions.fail((String)"Embedded NodeJs installation is not used");
    }
}

