/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.node;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.node.VSCodeJSDebugDelegate;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class NodeAttachDebugDelegate
extends VSCodeJSDebugDelegate {
    static final String ID = "org.eclipse.wildwebdeveloper.launchConfiguration.nodeDebugAttach";
    static final String ADDRESS = "address";
    static final String LOCAL_ROOT = "localRoot";
    static final String REMOTE_ROOT = "remoteRoot";

    public NodeAttachDebugDelegate() {
        super("pwa-node");
    }

    @Override
    public void launch(ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File runtimeExecutable;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("request", "attach");
        param.put(ADDRESS, configuration.getAttribute(ADDRESS, "no address defined"));
        param.put("port", configuration.getAttribute("port", -1));
        param.put("type", this.type);
        param.put("continueOnAttach", true);
        if (configuration.hasAttribute(LOCAL_ROOT)) {
            param.put(LOCAL_ROOT, VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(configuration.getAttribute(LOCAL_ROOT, "")));
        }
        if (configuration.hasAttribute(REMOTE_ROOT)) {
            param.put(REMOTE_ROOT, configuration.getAttribute(REMOTE_ROOT, ""));
        }
        if ((runtimeExecutable = NodeJSManager.getNodeJsLocation()) != null) {
            param.put("runtimeExecutable", runtimeExecutable.getAbsolutePath());
        }
        try {
            URL fileURL = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/js-debug/src/dapDebugServer.js"));
            File file = new File(fileURL.getPath());
            int port = 0;
            try {
                Throwable throwable = null;
                Object var11_15 = null;
                try (ServerSocket serverSocket = new ServerSocket(0);){
                    port = serverSocket.getLocalPort();
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                Activator.getDefault().getLog().log(Status.error((String)ex.getMessage(), (Throwable)ex));
            }
            final Process vscodeJsDebugExec = DebugPlugin.exec((String[])new String[]{runtimeExecutable.getAbsolutePath(), file.getAbsolutePath(), Integer.toString(port)}, (File)new File(System.getProperty("user.dir")), (String[])new String[]{"DA_TEST_DISABLE_TELEMETRY=true"}, (boolean)false);
            final IProcess vscodeJsDebugIProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)vscodeJsDebugExec, (String)"debug adapter");
            AtomicBoolean started = new AtomicBoolean();
            vscodeJsDebugIProcess.getStreamsProxy().getOutputStreamMonitor().addListener((text, mon) -> {
                if (text.toLowerCase().contains("listening")) {
                    started.set(true);
                }
            });
            Instant request = Instant.now();
            while (!started.get() && Duration.between(request, Instant.now()).compareTo(Duration.ofSeconds(3L)) < 3) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder(configuration, mode, launch, monitor);
            builder.setAttachDebugAdapter("::1", port);
            builder.setMonitorDebugAdapter(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false));
            builder.setDspParameters(param);
            super.launch(builder);
            IDebugEventSetListener shutdownParentOnCompletion = new IDebugEventSetListener(){

                public void handleDebugEvents(DebugEvent[] events) {
                    if (Arrays.stream(events).anyMatch(event -> {
                        IDebugTarget target;
                        Object object;
                        return event.getKind() == 8 && (object = event.getSource()) instanceof IDebugTarget && (target = (IDebugTarget)object).getLaunch() == launch;
                    }) && Arrays.stream(launch.getDebugTargets()).allMatch(ITerminate::isTerminated) && List.of(vscodeJsDebugIProcess).equals(Arrays.stream(launch.getProcesses()).filter(Predicate.not(ITerminate::isTerminated)).toList())) {
                        try {
                            vscodeJsDebugIProcess.terminate();
                        }
                        catch (DebugException ex) {
                            vscodeJsDebugExec.destroy();
                        }
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    }
                }
            };
            DebugPlugin.getDefault().addDebugEventListener(shutdownParentOnCompletion);
        }
        catch (IOException e) {
            Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
            Display.getDefault().asyncExec(() -> NodeAttachDebugDelegate.lambda$1(e, (IStatus)errorStatus));
        }
    }

    private static /* synthetic */ void lambda$1(IOException iOException, IStatus iStatus) {
        int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug error", (String)iOException.getMessage(), (IStatus)iStatus);
    }
}

