/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.wtpbuilder.test;

import org.eclipse.wtp.releng.wtpbuilder.AbstractBuilder;
import org.eclipse.wtp.releng.wtpbuilder.Build;
import org.eclipse.wtp.releng.wtpbuilder.CommandOptionParser;
import org.eclipse.wtp.releng.wtpbuilder.Main;

public class TestBuilder
extends AbstractBuilder {
    private static final String TEST_SUITE_COMPLETED_BUILDS_FILE = "test_suite_completed_builds.properties";
    private static final String USAGE = "Usage: java org.eclipse.wtp.releng.wtpbuilder.test.TestBuilder -baseos <baseos> -basews <basews> -basearch <basearch> -build.home <buildHome>";
    private static final String BUILD_SCRIPT = "/releng.wtpbuilder/distribution/wtp.tests/standaloneTest.xml";

    public TestBuilder(String completedBuildsFile) {
        super(completedBuildsFile);
    }

    public boolean build(Build build) {
        System.setProperty("buildType", build.getType());
        System.setProperty("buildId", build.getId());
        System.setProperty("timestamp", build.getDate() + build.getTime());
        System.setProperty("build.stream", build.getStream());
        System.setProperty("buildBranch", build.getStream());
        if (!build.isPublicBuild()) {
            System.setProperty("build.committers", Boolean.TRUE.toString());
        }
        String buildScript = System.getProperty("build.home") + BUILD_SCRIPT;
        Main.main(new String[]{"-f", buildScript});
        Main.main(new String[]{"-f", buildScript, "upload"});
        Main.main(new String[]{"-f", buildScript, "clean"});
        return true;
    }

    public static void main(String[] args) {
        CommandOptionParser parser = new CommandOptionParser(args);
        String baseos = parser.getOptionAsString("baseos");
        String basews = parser.getOptionAsString("basews");
        String basearch = parser.getOptionAsString("basearch");
        String login = parser.getOptionAsString("login");
        String config = parser.getOptionAsString("config");
        String minTS = parser.getOptionAsString("minTS");
        String buildHome = parser.getOptionAsString("build.home");
        if (baseos == null || basews == null || basearch == null || buildHome == null) {
            System.out.println(USAGE);
            System.exit(-1);
        }
        TestBuilder testBuilder = new TestBuilder(TEST_SUITE_COMPLETED_BUILDS_FILE);
        testBuilder.setBaseos(baseos);
        testBuilder.setBasews(basews);
        testBuilder.setBasearch(basearch);
        testBuilder.setLogin(login);
        System.setProperty("config", config);
        System.setProperty("build.home", buildHome);
        if (minTS != null) {
            testBuilder.setMinTS(Long.parseLong(minTS));
        }
        testBuilder.main();
    }
}

