/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.util.Vector;

public class StringMatcher {
    protected String fPattern;
    protected int fLength;
    protected boolean fIgnoreWildCards;
    protected boolean fIgnoreCase;
    protected boolean fHasLeadingStar;
    protected boolean fHasTrailingStar;
    protected String[] fSegments;
    protected int fBound = 0;
    protected static final char fSingleWildCard = '\u0000';

    public StringMatcher(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this.fIgnoreCase = ignoreCase;
        this.fIgnoreWildCards = ignoreWildCards;
        this.fPattern = pattern;
        this.fLength = pattern.length();
        if (this.fIgnoreWildCards) {
            this.parseNoWildCards();
        } else {
            this.parseWildCards();
        }
    }

    public Position find(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        int tlen = text.length();
        int innerStart = start;
        int innerEnd = end;
        if (innerStart < 0) {
            innerStart = 0;
        }
        if (innerEnd > tlen) {
            innerEnd = tlen;
        }
        if (innerEnd < 0 || innerStart >= innerEnd) {
            return null;
        }
        if (this.fLength == 0) {
            return new Position(innerStart, innerStart);
        }
        if (this.fIgnoreWildCards) {
            int x = this.posIn(text, innerStart, innerEnd);
            if (x < 0) {
                return null;
            }
            return new Position(x, x + this.fLength);
        }
        int segCount = this.fSegments.length;
        if (segCount == 0) {
            return new Position(innerStart, innerEnd);
        }
        int curPos = innerStart;
        int matchStart = -1;
        int i = 0;
        while (i < segCount && curPos < innerEnd) {
            String current = this.fSegments[i];
            int nextMatch = this.regExpPosIn(text, curPos, innerEnd, current);
            if (nextMatch < 0) {
                return null;
            }
            if (i == 0) {
                matchStart = nextMatch;
            }
            curPos = nextMatch + current.length();
            ++i;
        }
        if (i < segCount) {
            return null;
        }
        return new Position(matchStart, curPos);
    }

    public boolean match(String text) {
        return this.match(text, 0, text.length());
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        innerStart = start;
        innerEnd = end;
        if (innerStart > innerEnd) {
            return false;
        }
        if (this.fIgnoreWildCards) {
            return innerEnd - innerStart == this.fLength && this.fPattern.regionMatches(this.fIgnoreCase, 0, text, innerStart, this.fLength) != false;
        }
        segCount = this.fSegments.length;
        if (segCount == 0 && (this.fHasLeadingStar || this.fHasTrailingStar)) {
            return true;
        }
        if (innerStart == innerEnd) {
            return this.fLength == 0;
        }
        if (this.fLength == 0) {
            return innerStart == innerEnd;
        }
        tlen = text.length();
        if (innerStart < 0) {
            innerStart = 0;
        }
        if (innerEnd > tlen) {
            innerEnd = tlen;
        }
        tCurPos = innerStart;
        bound = innerEnd - this.fBound;
        if (bound < 0) {
            return false;
        }
        i = 0;
        current = this.fSegments[i];
        segLength = current.length();
        if (!this.fHasLeadingStar) {
            if (!this.regExpRegionMatches(text, innerStart, current, 0, segLength)) {
                return false;
            }
            ++i;
            tCurPos += segLength;
        }
        if (this.fSegments.length != 1 || this.fHasLeadingStar || this.fHasTrailingStar) ** GOTO lbl41
        return tCurPos == innerEnd;
lbl-1000:
        // 1 sources

        {
            current = this.fSegments[i];
            k = current.indexOf(0);
            if (k < 0 ? (currentMatch = this.textPosIn(text, tCurPos, innerEnd, current)) < 0 : (currentMatch = this.regExpPosIn(text, tCurPos, innerEnd, current)) < 0) {
                return false;
            }
            tCurPos = currentMatch + current.length();
            ++i;
lbl41:
            // 2 sources

            ** while (i < segCount)
        }
lbl42:
        // 1 sources

        if (!this.fHasTrailingStar && tCurPos != innerEnd) {
            clen = current.length();
            return this.regExpRegionMatches(text, innerEnd - clen, current, 0, clen);
        }
        return i == segCount;
    }

    private void parseNoWildCards() {
        this.fSegments = new String[1];
        this.fSegments[0] = this.fPattern;
        this.fBound = this.fLength;
    }

    private void parseWildCards() {
        if (this.fPattern.startsWith("*")) {
            this.fHasLeadingStar = true;
        }
        if (this.fPattern.endsWith("*") && this.fLength > 1 && this.fPattern.charAt(this.fLength - 2) != '\\') {
            this.fHasTrailingStar = true;
        }
        Vector<String> temp = new Vector<String>();
        int pos = 0;
        StringBuffer buf = new StringBuffer();
        block5: while (pos < this.fLength) {
            char c = this.fPattern.charAt(pos++);
            switch (c) {
                case '\\': {
                    char next;
                    if (pos >= this.fLength) {
                        buf.append(c);
                        break;
                    }
                    if ((next = this.fPattern.charAt(pos++)) == '*' || next == '?' || next == '\\') {
                        buf.append(next);
                        break;
                    }
                    buf.append(c);
                    buf.append(next);
                    break;
                }
                case '*': {
                    if (buf.length() <= 0) continue block5;
                    temp.addElement(buf.toString());
                    this.fBound += buf.length();
                    buf.setLength(0);
                    break;
                }
                case '?': {
                    buf.append('\u0000');
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            temp.addElement(buf.toString());
            this.fBound += buf.length();
        }
        this.fSegments = new String[temp.size()];
        temp.copyInto(this.fSegments);
    }

    protected int posIn(String text, int start, int end) {
        int max = end - this.fLength;
        if (!this.fIgnoreCase) {
            int i = text.indexOf(this.fPattern, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, this.fPattern, 0, this.fLength)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int regExpPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        int i = start;
        while (i <= max) {
            if (this.regExpRegionMatches(text, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String text, int tStart, String p, int pStart, int plen) {
        int innerPlen = plen;
        int innerTStart = tStart;
        int innerPStart = pStart;
        while (innerPlen-- > 0) {
            char tchar = text.charAt(innerTStart++);
            char pchar = p.charAt(innerPStart++);
            if (!this.fIgnoreWildCards && pchar == '\u0000' || pchar == tchar || this.fIgnoreCase && (Character.toUpperCase(tchar) == Character.toUpperCase(pchar) || Character.toLowerCase(tchar) == Character.toLowerCase(pchar))) continue;
            return false;
        }
        return true;
    }

    protected int textPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        if (!this.fIgnoreCase) {
            int i = text.indexOf(p, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static class Position {
        int start;
        int end;

        public Position(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

