/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.jca;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransactionSupportType implements Enumerator
{
    NO_TRANSACTION(0, "NoTransaction", "NoTransaction"),
    LOCAL_TRANSACTION(1, "LocalTransaction", "LocalTransaction"),
    XA_TRANSACTION(2, "XATransaction", "XATransaction");

    public static final int NO_TRANSACTION_VALUE = 0;
    public static final int LOCAL_TRANSACTION_VALUE = 1;
    public static final int XA_TRANSACTION_VALUE = 2;
    private static final TransactionSupportType[] VALUES_ARRAY;
    public static final List<TransactionSupportType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TransactionSupportType[]{NO_TRANSACTION, LOCAL_TRANSACTION, XA_TRANSACTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TransactionSupportType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransactionSupportType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransactionSupportType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransactionSupportType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransactionSupportType get(int value) {
        switch (value) {
            case 0: {
                return NO_TRANSACTION;
            }
            case 1: {
                return LOCAL_TRANSACTION;
            }
            case 2: {
                return XA_TRANSACTION;
            }
        }
        return null;
    }

    private TransactionSupportType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

