/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class JavadocConfigurationBlock {
    private static final String FILE_IMPORT_MASK = "*.jar;*.zip";
    private static final String ERROR_DIALOG_TITLE = "Error Dialog";
    private StringDialogField fURLField;
    private StringDialogField fArchiveField;
    private StringDialogField fArchivePathField;
    private URL fInitialURL;
    private SelectionButtonDialogField fValidateURLButton;
    private SelectionButtonDialogField fValidateArchiveButton;
    private SelectionButtonDialogField fBrowseFolder;
    private SelectionButtonDialogField fURLRadioButton;
    private SelectionButtonDialogField fArchiveRadioButton;
    private SelectionButtonDialogField fBrowseArchive;
    private SelectionButtonDialogField fExternalRadio;
    private SelectionButtonDialogField fWorkspaceRadio;
    private SelectionButtonDialogField fBrowseArchivePath;
    private Shell fShell;
    private IStatusChangeListener fContext;
    private IStatus fURLStatus;
    private IStatus fArchiveStatus;
    private IStatus fArchivePathStatus;
    private URL fURLResult;
    private URL fArchiveURLResult;
    boolean fIsForSource;
    static /* synthetic */ Class class$0;

    public JavadocConfigurationBlock(Shell shell, IStatusChangeListener context, URL initURL, boolean forSource) {
        this.fShell = shell;
        this.fContext = context;
        this.fInitialURL = initURL;
        this.fIsForSource = forSource;
        JDocConfigurationAdapter adapter = new JDocConfigurationAdapter();
        if (!forSource) {
            this.fURLRadioButton = new SelectionButtonDialogField(16);
            this.fURLRadioButton.setDialogFieldListener(adapter);
            this.fURLRadioButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_type_path_label);
        }
        this.fURLField = new StringDialogField();
        this.fURLField.setDialogFieldListener(adapter);
        this.fURLField.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_path_label);
        this.fBrowseFolder = new SelectionButtonDialogField(8);
        this.fBrowseFolder.setDialogFieldListener(adapter);
        this.fBrowseFolder.setLabelText(PreferencesMessages.JavadocConfigurationBlock_browse_folder_button);
        this.fValidateURLButton = new SelectionButtonDialogField(8);
        this.fValidateURLButton.setDialogFieldListener(adapter);
        this.fValidateURLButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_validate_button);
        if (!forSource) {
            this.fArchiveRadioButton = new SelectionButtonDialogField(16);
            this.fArchiveRadioButton.setDialogFieldListener(adapter);
            this.fArchiveRadioButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_type_jar_label);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setDialogFieldListener(adapter);
            this.fExternalRadio.setLabelText(PreferencesMessages.JavadocConfigurationBlock_external_radio);
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(adapter);
            this.fWorkspaceRadio.setLabelText(PreferencesMessages.JavadocConfigurationBlock_workspace_radio);
            this.fArchiveField = new StringDialogField();
            this.fArchiveField.setDialogFieldListener(adapter);
            this.fArchiveField.setLabelText(PreferencesMessages.JavadocConfigurationBlock_location_jar_label);
            this.fBrowseArchive = new SelectionButtonDialogField(8);
            this.fBrowseArchive.setDialogFieldListener(adapter);
            this.fBrowseArchive.setLabelText(PreferencesMessages.JavadocConfigurationBlock_browse_archive_button);
            this.fArchivePathField = new StringDialogField();
            this.fArchivePathField.setDialogFieldListener(adapter);
            this.fArchivePathField.setLabelText(PreferencesMessages.JavadocConfigurationBlock_jar_path_label);
            this.fBrowseArchivePath = new SelectionButtonDialogField(8);
            this.fBrowseArchivePath.setDialogFieldListener(adapter);
            this.fBrowseArchivePath.setLabelText(PreferencesMessages.JavadocConfigurationBlock_browse_archive_path_button);
            this.fValidateArchiveButton = new SelectionButtonDialogField(8);
            this.fValidateArchiveButton.setDialogFieldListener(adapter);
            this.fValidateArchiveButton.setLabelText(PreferencesMessages.JavadocConfigurationBlock_validate_button);
        }
        this.fURLStatus = new StatusInfo();
        this.fArchiveStatus = new StatusInfo();
        this.fArchivePathStatus = new StatusInfo();
        this.initializeSelections();
    }

    public Control createContents(Composite parent) {
        this.fShell = parent.getShell();
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite topComp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        topComp.setLayout((Layout)topLayout);
        if (!this.fIsForSource) {
            this.fURLRadioButton.doFillIntoGrid(topComp, 3);
        }
        this.fURLField.doFillIntoGrid(topComp, 2);
        LayoutUtil.setWidthHint((Control)this.fURLField.getTextControl(null), converter.convertWidthInCharsToPixels(43));
        LayoutUtil.setHorizontalGrabbing((Control)this.fURLField.getTextControl(null));
        this.fBrowseFolder.doFillIntoGrid(topComp, 1);
        DialogField.createEmptySpace(topComp, 2);
        this.fValidateURLButton.doFillIntoGrid(topComp, 1);
        if (!this.fIsForSource) {
            this.fArchiveRadioButton.doFillIntoGrid(topComp, 3);
            DialogField.createEmptySpace(topComp, 1);
            Composite radioComposite = new Composite(topComp, 0);
            radioComposite.setLayoutData((Object)new GridData(4, 4, false, false));
            GridLayout layout = new GridLayout(2, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            radioComposite.setLayout((Layout)layout);
            this.fExternalRadio.doFillIntoGrid(radioComposite, 1);
            this.fWorkspaceRadio.doFillIntoGrid(radioComposite, 1);
            DialogField.createEmptySpace(topComp, 1);
            this.fArchiveField.doFillIntoGrid(topComp, 2);
            LayoutUtil.setWidthHint((Control)this.fArchiveField.getTextControl(null), converter.convertWidthInCharsToPixels(43));
            LayoutUtil.setHorizontalGrabbing((Control)this.fArchiveField.getTextControl(null));
            this.fBrowseArchive.doFillIntoGrid(topComp, 1);
            this.fArchivePathField.doFillIntoGrid(topComp, 2);
            LayoutUtil.setWidthHint((Control)this.fArchivePathField.getTextControl(null), converter.convertWidthInCharsToPixels(43));
            LayoutUtil.setHorizontalGrabbing((Control)this.fArchivePathField.getTextControl(null));
            this.fBrowseArchivePath.doFillIntoGrid(topComp, 1);
            DialogField.createEmptySpace(topComp, 2);
            this.fValidateArchiveButton.doFillIntoGrid(topComp, 1);
            int indent = converter.convertWidthInCharsToPixels(2);
            LayoutUtil.setHorizontalIndent((Control)this.fArchiveField.getLabelControl(null), indent);
            LayoutUtil.setHorizontalIndent((Control)this.fArchivePathField.getLabelControl(null), indent);
            LayoutUtil.setHorizontalIndent((Control)this.fURLField.getLabelControl(null), indent);
            this.fURLRadioButton.attachDialogFields(new DialogField[]{this.fURLField, this.fBrowseFolder, this.fValidateURLButton});
            this.fArchiveRadioButton.attachDialogFields(new DialogField[]{this.fArchiveField, this.fBrowseArchive, this.fExternalRadio, this.fWorkspaceRadio, this.fArchivePathField, this.fBrowseArchivePath, this.fValidateArchiveButton});
        }
        return topComp;
    }

    private void initializeSelections() {
        String initialValue;
        String string = initialValue = this.fInitialURL != null ? this.fInitialURL.toExternalForm() : "";
        if (this.fIsForSource) {
            this.fURLField.setText(initialValue);
            return;
        }
        String prefix = "jar:";
        boolean isArchive = initialValue.startsWith(prefix);
        boolean isWorkspaceArchive = false;
        this.fURLRadioButton.setSelection(!isArchive);
        this.fArchiveRadioButton.setSelection(isArchive);
        if (isArchive) {
            String jarPathStr;
            String insidePath = "";
            int excIndex = initialValue.indexOf("!/");
            if (excIndex == -1) {
                jarPathStr = initialValue.substring(prefix.length());
            } else {
                jarPathStr = initialValue.substring(prefix.length(), excIndex);
                insidePath = initialValue.substring(excIndex + 2);
            }
            if (jarPathStr.startsWith("file:/")) {
                jarPathStr = jarPathStr.substring("file:/".length());
            } else if (jarPathStr.startsWith("platform:/resource/")) {
                jarPathStr = jarPathStr.substring("platform:/resource/".length());
                isWorkspaceArchive = true;
            } else {
                this.fURLField.setText(initialValue);
                return;
            }
            Path jarPath = new Path(this.decodeExclamationMarks(jarPathStr));
            this.fArchivePathField.setText(this.decodeExclamationMarks(insidePath));
            if (isWorkspaceArchive) {
                this.fArchiveField.setText(jarPath.makeRelative().toString());
            } else {
                this.fArchiveField.setText(jarPath.makeAbsolute().toOSString());
            }
        } else {
            this.fURLField.setText(initialValue);
        }
        this.fExternalRadio.setSelection(!isWorkspaceArchive);
        this.fWorkspaceRadio.setSelection(isWorkspaceArchive);
    }

    public void setFocus() {
        this.fURLField.postSetFocusOnDialogField(this.fShell.getDisplay());
    }

    public void performDefaults() {
        this.initializeSelections();
    }

    public URL getJavadocLocation() {
        if (this.fIsForSource || this.fURLRadioButton.isSelected()) {
            return this.fURLResult;
        }
        return this.fArchiveURLResult;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkURLConnection(URL url) {
        int res = 0;
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                connection.connect();
                res = ((HttpURLConnection)connection).getResponseCode();
            }
            InputStream is = null;
            try {
                is = connection.getInputStream();
                byte[] buffer = new byte[256];
                while (is.read(buffer) != -1) {
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (is == null) return res < 400;
                is.close();
                return res < 400;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void jdocDialogFieldChanged(DialogField field) {
        if (field == this.fURLField) {
            this.fURLStatus = this.updateURLStatus();
            this.statusChanged();
        } else if (field == this.fArchiveField) {
            this.fArchiveStatus = this.updateArchiveStatus();
            this.statusChanged();
        } else if (field == this.fArchivePathField) {
            this.fArchivePathStatus = this.updateArchivePathStatus();
            this.statusChanged();
        } else if (field == this.fValidateURLButton || field == this.fValidateArchiveButton) {
            EntryValidator validator = new EntryValidator();
            BusyIndicator.showWhile((Display)this.fShell.getDisplay(), (Runnable)validator);
        } else if (field == this.fBrowseFolder) {
            String url = this.chooseJavaDocFolder();
            if (url != null) {
                this.fURLField.setText(url);
            }
        } else if (field == this.fBrowseArchive) {
            String jarPath = this.chooseArchive();
            if (jarPath != null) {
                this.fArchiveField.setText(jarPath);
            }
        } else if (field == this.fExternalRadio || field == this.fWorkspaceRadio) {
            this.fArchiveStatus = this.updateArchiveStatus();
            this.statusChanged();
        } else if (field == this.fBrowseArchivePath) {
            String archivePath = this.chooseArchivePath();
            if (archivePath != null) {
                this.fArchivePathField.setText(archivePath);
            }
        } else if (field == this.fURLRadioButton || field == this.fArchiveRadioButton) {
            this.statusChanged();
        }
    }

    private void statusChanged() {
        boolean isURL = this.fIsForSource || this.fURLRadioButton.isSelected();
        IStatus status = isURL ? this.fURLStatus : StatusUtil.getMoreSevere(this.fArchiveStatus, this.fArchivePathStatus);
        if (!this.fIsForSource) {
            boolean canBrowseArchivePath;
            boolean bl = canBrowseArchivePath = !isURL && this.fArchiveStatus.isOK() && this.fArchiveField.getText().length() > 0;
            if (canBrowseArchivePath && this.fWorkspaceRadio.isSelected()) {
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.fArchiveField.getText()));
                canBrowseArchivePath = resource != null && resource.getLocation() != null;
            }
            this.fBrowseArchivePath.setEnabled(canBrowseArchivePath);
        }
        this.fContext.statusChanged(status);
    }

    private String chooseArchivePath() {
        final String[] res = new String[1];
        BusyIndicator.showWhile((Display)this.fShell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                res[0] = JavadocConfigurationBlock.this.internalChooseArchivePath();
            }
        });
        return res[0];
    }

    private String encodeExclamationMarks(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == '!') {
                buf.append("%21");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    private String decodeExclamationMarks(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        int length = str.length();
        int i = 0;
        while (i < length) {
            char ch = str.charAt(i);
            if (ch == '%' && i < length - 2 && str.charAt(i + 1) == '2' && str.charAt(i + 2) == '1') {
                buf.append('!');
                i += 2;
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * Exception decompiling
     */
    private String internalChooseArchivePath() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 309->312)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String chooseArchive() {
        if (this.fWorkspaceRadio.isSelected()) {
            return this.chooseWorkspaceArchive();
        }
        Path currPath = new Path(this.fArchiveField.getText());
        if (ArchiveFileFilter.isArchivePath((IPath)currPath)) {
            currPath = currPath.removeLastSegments(1);
        }
        FileDialog dialog = new FileDialog(this.fShell, 4096);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        dialog.setText(PreferencesMessages.JavadocConfigurationBlock_zipImportSource_title);
        dialog.setFilterPath(currPath.toOSString());
        return dialog.open();
    }

    private String chooseWorkspaceArchive() {
        String initSelection = this.fArchiveField.getText();
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        IResource initSel = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (initSelection.length() > 0) {
            initSel = root.findMember((IPath)new Path(initSelection));
        }
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.fShell, (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.addFilter((ViewerFilter)new ArchiveFileFilter(null, true));
        dialog.setAllowMultiple(false);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setTitle(PreferencesMessages.JavadocConfigurationBlock_workspace_archive_selection_dialog_title);
        dialog.setMessage(PreferencesMessages.JavadocConfigurationBlock_workspace_archive_selection_dialog_description);
        dialog.setInput((Object)root);
        dialog.setInitialSelection((Object)initSel);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            return res.getFullPath().makeRelative().toString();
        }
        return null;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.fShell, (String)ERROR_DIALOG_TITLE, (String)message);
    }

    private String chooseJavaDocFolder() {
        String initPath = "";
        if (this.fURLResult != null && "file".equals(this.fURLResult.getProtocol())) {
            initPath = new File(this.fURLResult.getFile()).getPath();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.fShell);
        dialog.setText(PreferencesMessages.JavadocConfigurationBlock_javadocFolderDialog_label);
        dialog.setMessage(PreferencesMessages.JavadocConfigurationBlock_javadocFolderDialog_message);
        dialog.setFilterPath(initPath);
        String result = dialog.open();
        if (result != null) {
            try {
                URL url = new File(result).toURL();
                return url.toExternalForm();
            }
            catch (MalformedURLException e) {
                JavaScriptPlugin.log(e);
            }
        }
        return null;
    }

    private IStatus updateURLStatus() {
        StatusInfo status = new StatusInfo();
        this.fURLResult = null;
        try {
            String jdocLocation = this.fURLField.getText();
            if (jdocLocation.length() == 0) {
                return status;
            }
            URL url = new URL(jdocLocation);
            if ("file".equals(url.getProtocol()) && url.getFile() == null) {
                status.setError(PreferencesMessages.JavadocConfigurationBlock_error_notafolder);
                return status;
            }
            this.fURLResult = url;
        }
        catch (MalformedURLException malformedURLException) {
            status.setError(PreferencesMessages.JavadocConfigurationBlock_MalformedURL_error);
            return status;
        }
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus updateArchiveStatus() {
        try {
            this.fArchiveURLResult = null;
            StatusInfo status = new StatusInfo();
            String jdocLocation = this.fArchiveField.getText();
            if (jdocLocation.length() > 0) {
                if (!Path.ROOT.isValidPath(jdocLocation)) {
                    status.setError(PreferencesMessages.JavadocConfigurationBlock_error_invalidarchivepath);
                    return status;
                }
                if (this.fWorkspaceRadio.isSelected()) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IResource res = root.findMember((IPath)new Path(jdocLocation));
                    if (res == null) {
                        status.setError(PreferencesMessages.JavadocConfigurationBlock_error_archive_not_found_in_workspace);
                        return status;
                    }
                    if (!(res instanceof IFile)) {
                        status.setError(PreferencesMessages.JavadocConfigurationBlock_error_archive_not_found_in_workspace);
                        return status;
                    }
                } else {
                    IPath path = Path.fromOSString((String)jdocLocation);
                    if (!path.isAbsolute()) {
                        status.setError(PreferencesMessages.JavadocConfigurationBlock_error_archivepathnotabsolute);
                        return status;
                    }
                    File jarFile = new File(jdocLocation);
                    if (jarFile.isDirectory()) {
                        status.setError(PreferencesMessages.JavadocConfigurationBlock_error_notafile);
                        return status;
                    }
                    if (!jarFile.exists()) {
                        status.setWarning(PreferencesMessages.JavadocConfigurationBlock_error_notafile);
                    }
                }
                this.fArchiveURLResult = this.getArchiveURL();
            }
            return status;
        }
        catch (MalformedURLException e) {
            StatusInfo status = new StatusInfo();
            status.setError(e.getMessage());
            return status;
        }
    }

    private IStatus updateArchivePathStatus() {
        try {
            this.fArchiveURLResult = this.getArchiveURL();
        }
        catch (MalformedURLException e) {
            this.fArchiveURLResult = null;
            StatusInfo status = new StatusInfo();
            status.setError(e.getMessage());
            return status;
        }
        return new StatusInfo();
    }

    private URL getArchiveURL() throws MalformedURLException {
        String jarLoc = this.fArchiveField.getText();
        String innerPath = this.fArchivePathField.getText().trim();
        StringBuffer buf = new StringBuffer();
        buf.append("jar:");
        if (this.fWorkspaceRadio.isSelected()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource res = root.findMember((IPath)new Path(jarLoc));
            if (res != null) {
                buf.append("platform:/resource").append(this.encodeExclamationMarks(res.getFullPath().toString()));
            }
        } else {
            buf.append(this.encodeExclamationMarks(new File(jarLoc).toURL().toExternalForm()));
        }
        buf.append('!');
        if (innerPath.length() > 0) {
            if (innerPath.charAt(0) != '/') {
                buf.append('/');
            }
            buf.append(innerPath);
        } else {
            buf.append('/');
        }
        return new URL(buf.toString());
    }

    private class EntryValidator
    implements Runnable {
        private String fInvalidMessage = PreferencesMessages.JavadocConfigurationBlock_InvalidLocation_message;
        private String fValidMessage = PreferencesMessages.JavadocConfigurationBlock_ValidLocation_message;
        private String fTitle = PreferencesMessages.JavadocConfigurationBlock_MessageDialog_title;
        private String fUnable = PreferencesMessages.JavadocConfigurationBlock_UnableToValidateLocation_message;

        private EntryValidator() {
        }

        public void run() {
            URL location = JavadocConfigurationBlock.this.getJavadocLocation();
            if (location == null) {
                MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
                return;
            }
            try {
                String protocol = location.getProtocol();
                if (protocol.startsWith("http") || protocol.equals("jar")) {
                    this.validateURL(location);
                } else if (protocol.equals("file")) {
                    this.validateFile(location);
                } else {
                    MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fUnable);
                }
            }
            catch (MalformedURLException malformedURLException) {
                MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fUnable);
            }
        }

        public void spawnInBrowser(URL url) {
            OpenBrowserUtil.open(url, JavadocConfigurationBlock.this.fShell.getDisplay(), this.fTitle);
        }

        private void validateFile(URL location) throws MalformedURLException {
            File indexFile;
            File folder = new File(location.getFile());
            if (folder.isDirectory() && (indexFile = new File(folder, "index.html")).isFile()) {
                if (MessageDialog.openConfirm((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fValidMessage)) {
                    this.spawnInBrowser(indexFile.toURL());
                }
                return;
            }
            MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
        }

        private void validateURL(URL location) throws MalformedURLException {
            boolean suc;
            Path path = new Path(location.toExternalForm());
            IPath index = path.append("index.html");
            IPath packagelist = path.append("package-list");
            URL indexURL = new URL(index.toString());
            URL packagelistURL = new URL(packagelist.toString());
            boolean bl = suc = JavadocConfigurationBlock.this.checkURLConnection(indexURL) && JavadocConfigurationBlock.this.checkURLConnection(packagelistURL);
            if (suc) {
                if (MessageDialog.openConfirm((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fValidMessage)) {
                    this.spawnInBrowser(indexURL);
                }
            } else {
                MessageDialog.openWarning((Shell)JavadocConfigurationBlock.this.fShell, (String)this.fTitle, (String)this.fInvalidMessage);
            }
        }
    }

    private class JDocConfigurationAdapter
    implements IDialogFieldListener {
        private JDocConfigurationAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            JavadocConfigurationBlock.this.jdocDialogFieldChanged(field);
        }
    }

    private static class ZipDialogContentProvider
    implements ITreeContentProvider {
        private ZipFileStructureProvider fProvider;

        public ZipDialogContentProvider(ZipFileStructureProvider provider) {
            this.fProvider = provider;
        }

        public Object findElement(IPath path) {
            String[] segments = path.segments();
            ZipEntry elem = this.fProvider.getRoot();
            int i = 0;
            while (i < segments.length && elem != null) {
                List list = this.fProvider.getChildren((Object)elem);
                String name = segments[i];
                elem = null;
                int k = 0;
                while (k < list.size()) {
                    Object curr = list.get(k);
                    if (this.fProvider.isFolder(curr) && name.equals(this.fProvider.getLabel(curr))) {
                        elem = curr;
                        break;
                    }
                    ++k;
                }
                ++i;
            }
            return elem;
        }

        private Object recursiveFind(Object element, String name) {
            if (name.equals(this.fProvider.getLabel(element))) {
                return element;
            }
            List list = this.fProvider.getChildren(element);
            if (list != null) {
                int k = 0;
                while (k < list.size()) {
                    Object res = this.recursiveFind(list.get(k), name);
                    if (res != null) {
                        return res;
                    }
                    ++k;
                }
            }
            return null;
        }

        public Object findFileByName(String name) {
            return this.recursiveFind(this.fProvider.getRoot(), name);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            if (element.equals(this.fProvider.getRoot())) {
                return null;
            }
            Path path = new Path(this.fProvider.getFullPath(element));
            if (path.segmentCount() > 0) {
                return this.findElement(path.removeLastSegments(1));
            }
            return this.fProvider.getRoot();
        }

        public boolean hasChildren(Object element) {
            List list = this.fProvider.getChildren(element);
            if (list != null) {
                int i = 0;
                while (i < list.size()) {
                    if (this.fProvider.isFolder(list.get(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public Object[] getChildren(Object element) {
            List list = this.fProvider.getChildren(element);
            ArrayList res = new ArrayList();
            if (list != null) {
                int i = 0;
                while (i < list.size()) {
                    Object curr = list.get(i);
                    if (this.fProvider.isFolder(curr)) {
                        res.add(curr);
                    }
                    ++i;
                }
            }
            return res.toArray();
        }

        public Object[] getElements(Object element) {
            return new Object[]{this.fProvider.getRoot()};
        }

        public void dispose() {
        }
    }

    private static class ZipDialogLabelProvider
    extends LabelProvider {
        private final Image IMG_JAR = JavaScriptUI.getSharedImages().getImage("org.eclipse.wst.jsdt.ui.jar_obj.gif");
        private final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private ZipFileStructureProvider fProvider;

        public ZipDialogLabelProvider(ZipFileStructureProvider provider) {
            this.fProvider = provider;
        }

        public Image getImage(Object element) {
            if (element == this.fProvider.getRoot()) {
                return this.IMG_JAR;
            }
            return this.IMG_FOLDER;
        }

        public String getText(Object element) {
            if (element == this.fProvider.getRoot()) {
                return this.fProvider.getZipFile().getName();
            }
            return this.fProvider.getLabel(element);
        }
    }

    private static class ZipDialogValidator
    implements ISelectionStatusValidator {
        public IStatus validate(Object[] selection) {
            String message = "";
            return new StatusInfo(1, message);
        }
    }
}

