/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaVariable;
import org.eclipse.wst.jsdt.internal.corext.template.java.NameResolver;
import org.eclipse.wst.jsdt.internal.ui.text.template.contentassist.MultiVariable;

public class JavaContextType
extends CompilationUnitContextType {
    public static final String NAME = "javaScript";

    public JavaContextType() {
        super(NAME);
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver(new CompilationUnitContextType.File());
        this.addResolver(new CompilationUnitContextType.PrimaryTypeName());
        this.addResolver(new CompilationUnitContextType.ReturnType());
        this.addResolver(new CompilationUnitContextType.Method());
        this.addResolver(new CompilationUnitContextType.Type());
        this.addResolver(new CompilationUnitContextType.Package());
        this.addResolver(new CompilationUnitContextType.Project());
        this.addResolver(new CompilationUnitContextType.Arguments());
        this.addResolver(new Array());
        this.addResolver(new ArrayType());
        this.addResolver(new ArrayElement());
        this.addResolver(new Index());
        this.addResolver(new Todo());
    }

    public CompilationUnitContext createContext(IDocument document, int offset, int length, IJavaScriptUnit compilationUnit) {
        return new JavaContext(this, document, offset, length, compilationUnit);
    }

    public CompilationUnitContext createContext(IDocument document, Position completionPosition, IJavaScriptUnit compilationUnit) {
        return new JavaContext(this, document, completionPosition, compilationUnit);
    }

    protected static abstract class AbstractIterable
    extends TemplateVariableResolver {
        public AbstractIterable(String type, String description) {
            super(type, description);
        }

        protected String[] resolveAll(TemplateContext context) {
            JavaContext jc = (JavaContext)context;
            CompilationUnitCompletion.Variable[] iterables = this.getLocalVariables(jc);
            String[] names = new String[iterables.length];
            int i = 0;
            while (i < iterables.length) {
                names[i] = iterables[i].getName();
                ++i;
            }
            if (names.length > 0) {
                jc.markAsUsed(names[0]);
            }
            return names;
        }

        protected abstract CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext var1);

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                JavaContext jc = (JavaContext)context;
                JavaVariable jv = (JavaVariable)variable;
                Object[] iterables = this.getLocalVariables(jc);
                if (iterables.length > 0) {
                    jv.setChoices(iterables);
                    jc.markAsUsed(((CompilationUnitCompletion.Variable)iterables[0]).getName());
                    if (iterables.length > 1) {
                        variable.setUnambiguous(false);
                    } else {
                        variable.setUnambiguous(this.isUnambiguous(context));
                    }
                    return;
                }
            }
            super.resolve(variable, context);
        }
    }

    protected static abstract class AbstractIterableElement
    extends TemplateVariableResolver {
        private String fMasterName;

        public AbstractIterableElement(String type, String desc, String master) {
            super(type, desc);
            this.fMasterName = master;
        }

        protected String[] resolveAll(TemplateContext context) {
            JavaContext jc = (JavaContext)context;
            CompilationUnitCompletion.Variable[] iterables = this.getLocalVariables(jc);
            String[] elements = new String[iterables.length];
            int i = 0;
            while (i < iterables.length) {
                elements[i] = jc.suggestVariableNames(iterables[i].getMemberTypeNames()[0])[0];
                if (i == 0) {
                    jc.markAsUsed(elements[0]);
                }
                ++i;
            }
            return elements;
        }

        protected abstract CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext var1);

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                JavaContext jc = (JavaContext)context;
                MultiVariable mv = (MultiVariable)variable;
                CompilationUnitCompletion.Variable[] iterables = this.getLocalVariables(jc);
                if (iterables.length > 0) {
                    int i = 0;
                    while (i < iterables.length) {
                        Object[] elements = jc.suggestVariableNames(iterables[i].getMemberTypeNames()[0]);
                        mv.setChoices(iterables[i], elements);
                        ++i;
                    }
                    TemplateVariable master = jc.getTemplateVariable(this.fMasterName);
                    if (master instanceof MultiVariable) {
                        MultiVariable masterMv = (MultiVariable)master;
                        jc.addDependency(masterMv, mv);
                        mv.setKey(masterMv.getCurrentChoice());
                    }
                    jc.markAsUsed(mv.getDefaultValue());
                    if (iterables.length > 1 || iterables.length == 1 && mv.getChoices().length > 1) {
                        variable.setUnambiguous(false);
                    } else {
                        variable.setUnambiguous(this.isUnambiguous(context));
                    }
                    return;
                }
            }
            super.resolve(variable, context);
        }
    }

    protected static abstract class AbstractIterableType
    extends TemplateVariableResolver {
        private String fMasterName;

        public AbstractIterableType(String type, String desc, String master) {
            super(type, desc);
            this.fMasterName = master;
        }

        protected String[] resolveAll(TemplateContext context) {
            JavaContext jc = (JavaContext)context;
            CompilationUnitCompletion.Variable[] iterables = this.getLocalVariables(jc);
            String[] types = new String[iterables.length];
            int i = 0;
            while (i < iterables.length) {
                types[i] = iterables[i].getMemberTypeNames()[0];
                ++i;
            }
            return types;
        }

        protected abstract CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext var1);

        public void resolve(TemplateVariable variable, TemplateContext context) {
            if (variable instanceof MultiVariable) {
                JavaContext jc = (JavaContext)context;
                MultiVariable mv = (MultiVariable)variable;
                CompilationUnitCompletion.Variable[] iterables = this.getLocalVariables(jc);
                if (iterables.length > 0) {
                    int i = 0;
                    while (i < iterables.length) {
                        mv.setChoices(iterables[i], iterables[i].getMemberTypeNames());
                        ++i;
                    }
                    TemplateVariable master = jc.getTemplateVariable(this.fMasterName);
                    if (master instanceof MultiVariable) {
                        MultiVariable masterMv = (MultiVariable)master;
                        jc.addDependency(masterMv, mv);
                        mv.setKey(masterMv.getCurrentChoice());
                    }
                    if (iterables.length > 1 || iterables.length == 1 && mv.getChoices().length > 1) {
                        variable.setUnambiguous(false);
                    } else {
                        variable.setUnambiguous(this.isUnambiguous(context));
                    }
                    return;
                }
            }
            super.resolve(variable, context);
        }
    }

    protected static class Array
    extends AbstractIterable {
        public Array() {
            super("array", JavaTemplateMessages.JavaContextType_variable_description_array);
        }

        protected CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext jc) {
            return jc.getArrays();
        }
    }

    protected static class ArrayElement
    extends AbstractIterableElement {
        public ArrayElement() {
            super("array_element", JavaTemplateMessages.JavaContextType_variable_description_array_element, "array");
        }

        protected CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext jc) {
            return jc.getArrays();
        }
    }

    protected static class ArrayType
    extends AbstractIterableType {
        public ArrayType() {
            super("array_type", JavaTemplateMessages.JavaContextType_variable_description_array_type, "array");
        }

        protected CompilationUnitCompletion.Variable[] getLocalVariables(JavaContext jc) {
            return jc.getArrays();
        }
    }

    protected static class Index
    extends NameResolver {
        public Index() {
            super("int");
            this.setType("index");
            this.setDescription(JavaTemplateMessages.JavaContextType_variable_description_index);
        }
    }

    protected static class Todo
    extends TemplateVariableResolver {
        public Todo() {
            super("todo", JavaTemplateMessages.JavaContextType_variable_description_todo);
        }

        protected String resolve(TemplateContext context) {
            JavaContext javaContext = (JavaContext)context;
            IJavaScriptUnit compilationUnit = javaContext.getCompilationUnit();
            if (compilationUnit == null) {
                return "XXX";
            }
            IJavaScriptProject javaProject = compilationUnit.getJavaScriptProject();
            String todoTaskTag = StubUtility.getTodoTaskTag(javaProject);
            if (todoTaskTag == null) {
                return "XXX";
            }
            return todoTaskTag;
        }
    }
}

