/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.CopyElementsOperation;
import org.eclipse.wst.jsdt.internal.core.CopyResourceElementsOperation;
import org.eclipse.wst.jsdt.internal.core.DeleteElementsOperation;
import org.eclipse.wst.jsdt.internal.core.DeleteResourceElementsOperation;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.MoveElementsOperation;
import org.eclipse.wst.jsdt.internal.core.MoveResourceElementsOperation;
import org.eclipse.wst.jsdt.internal.core.MultiOperation;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.RenameElementsOperation;
import org.eclipse.wst.jsdt.internal.core.RenameResourceElementsOperation;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class JavaModel
extends Openable
implements IJavaScriptModel {
    public static HashSet existingExternalFiles = new HashSet();
    public static HashSet existingExternalConfirmedFiles = new HashSet();

    protected JavaModel() throws Error {
        super(null);
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int length = projects.length;
        IJavaScriptElement[] children = new IJavaScriptElement[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            IProject project = projects[i];
            if (JavaProject.hasJavaNature(project)) {
                children[index++] = this.getJavaProject((IResource)project);
            }
            ++i;
        }
        if (index < length) {
            IJavaScriptElement[] iJavaScriptElementArray = children;
            children = new IJavaScriptElement[index];
            System.arraycopy(iJavaScriptElementArray, 0, children, 0, index);
        }
        info.setChildren(children);
        newElements.put(this, info);
        return true;
    }

    public boolean contains(IResource resource) {
        IJavaScriptProject[] projects;
        switch (resource.getType()) {
            case 4: 
            case 8: {
                return true;
            }
        }
        try {
            projects = this.getJavaScriptProjects();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
        int i = 0;
        int length = projects.length;
        while (i < length) {
            JavaProject project = (JavaProject)projects[i];
            if (!project.contains(resource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void copy(IJavaScriptElement[] elements, IJavaScriptElement[] containers, IJavaScriptElement[] siblings, String[] renamings, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            this.runOperation(new CopyResourceElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        } else {
            this.runOperation(new CopyElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        }
    }

    protected Object createElementInfo() {
        return new JavaModelInfo();
    }

    public void delete(IJavaScriptElement[] elements, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            new DeleteResourceElementsOperation(elements, force).runOperation(monitor);
        } else {
            new DeleteElementsOperation(elements, force).runOperation(monitor);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaModel)) {
            return false;
        }
        return super.equals(o);
    }

    public int getElementType() {
        return 1;
    }

    public static void flushExternalFileCache() {
        existingExternalFiles = new HashSet();
        existingExternalConfirmedFiles = new HashSet();
    }

    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '=': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String projectName = memento.nextToken();
                JavaElement project = (JavaElement)((Object)this.getJavaScriptProject(projectName));
                return project.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected void getHandleMemento(StringBuffer buff) {
        buff.append(this.getElementName());
    }

    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }

    public IJavaScriptProject getJavaScriptProject(String projectName) {
        return new JavaProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), this);
    }

    public IJavaScriptProject getJavaProject(IResource resource) {
        switch (resource.getType()) {
            case 2: {
                return new JavaProject(((IFolder)resource).getProject(), this);
            }
            case 1: {
                return new JavaProject(((IFile)resource).getProject(), this);
            }
            case 4: {
                return new JavaProject((IProject)resource, this);
            }
        }
        throw new IllegalArgumentException(Messages.element_invalidResourceForProject);
    }

    public IJavaScriptProject[] getJavaScriptProjects() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(2);
        IJavaScriptProject[] array = new IJavaScriptProject[list.size()];
        list.toArray(array);
        return array;
    }

    public Object[] getNonJavaScriptResources() throws JavaScriptModelException {
        return ((JavaModelInfo)this.getElementInfo()).getNonJavaResources();
    }

    public IPath getPath() {
        return Path.ROOT;
    }

    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void move(IJavaScriptElement[] elements, IJavaScriptElement[] containers, IJavaScriptElement[] siblings, String[] renamings, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            this.runOperation(new MoveResourceElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        } else {
            this.runOperation(new MoveElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        }
    }

    public void refreshExternalArchives(IJavaScriptElement[] elementsScope, IProgressMonitor monitor) throws JavaScriptModelException {
        if (elementsScope == null) {
            elementsScope = new IJavaScriptElement[]{this};
        }
        JavaModelManager.getJavaModelManager().getDeltaProcessor().checkExternalArchiveChanges(elementsScope, monitor);
    }

    public void rename(IJavaScriptElement[] elements, IJavaScriptElement[] destinations, String[] renamings, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        MultiOperation op = elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7 ? new RenameResourceElementsOperation(elements, destinations, renamings, force) : new RenameElementsOperation(elements, destinations, renamings, force);
        op.runOperation(monitor);
    }

    protected void runOperation(MultiOperation op, IJavaScriptElement[] elements, IJavaScriptElement[] siblings, String[] renamings, IProgressMonitor monitor) throws JavaScriptModelException {
        op.setRenamings(renamings);
        if (siblings != null) {
            int i = 0;
            while (i < elements.length) {
                op.setInsertBefore(elements[i], siblings[i]);
                ++i;
            }
        }
        op.runOperation(monitor);
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("Java Model");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public static Object getTarget(IContainer container, IPath path, boolean checkResourceExistence) {
        IResource resource;
        if (path == null) {
            return null;
        }
        if (path.getDevice() == null && (resource = container.findMember(path)) != null) {
            if (!checkResourceExistence || resource.exists()) {
                return resource;
            }
            return null;
        }
        if (!path.isAbsolute()) {
            return null;
        }
        return JavaModel.getTargetAsExternalFile(path, checkResourceExistence);
    }

    private static synchronized Object getTargetAsExternalFile(IPath path, boolean checkResourceExistence) {
        File externalFile = new File(path.toOSString());
        if (!checkResourceExistence) {
            return externalFile;
        }
        if (existingExternalFiles.contains(externalFile)) {
            return externalFile;
        }
        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [JavaModel.getTarget(...)] Checking existence of " + path.toString());
        }
        if (externalFile.exists()) {
            existingExternalFiles.add(externalFile);
            return externalFile;
        }
        return null;
    }

    public static boolean isFile(Object target) {
        return JavaModel.getFile(target) != null;
    }

    public static synchronized File getFile(Object target) {
        File f;
        if (existingExternalConfirmedFiles.contains(target)) {
            return (File)target;
        }
        if (target instanceof File && (f = (File)target).exists()) {
            existingExternalConfirmedFiles.add(f);
            return f;
        }
        return null;
    }
}

