/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AddSourceFolderWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CreateMultipleSourceFoldersDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.EditFilterWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.NewContainerDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.wst.jsdt.ui.actions.AbstractOpenWizardAction;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class SourceContainerWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IJavaScriptProject fCurrJProject;
    private Control fSWTControl;
    private TreeListDialogField fFoldersList;
    private final int IDX_ADD = 0;
    private final int IDX_ADD_LINK = 1;
    private final int IDX_ADDEXT = 3;
    private final int IDX_ADDJAR = 4;
    private final int IDX_ADDVAR = 5;
    private final int IDX_EDIT = 7;
    private final int IDX_REMOVE = 8;

    private static AddSourceFolderWizard newSourceFolderWizard(CPListElement element, List existingElements, String outputLocation, boolean newFolder) {
        CPListElement[] existing = existingElements.toArray(new CPListElement[existingElements.size()]);
        AddSourceFolderWizard wizard = new AddSourceFolderWizard(existing, element, false, newFolder, newFolder, newFolder ? CPListElement.isProjectSourceFolder(existing, element.getJavaProject()) : false, newFolder);
        wizard.setDoFlushChange(false);
        return wizard;
    }

    private static AddSourceFolderWizard newLinkedSourceFolderWizard(CPListElement element, List existingElements, String outputLocation, boolean newFolder) {
        CPListElement[] existing = existingElements.toArray(new CPListElement[existingElements.size()]);
        AddSourceFolderWizard wizard = new AddSourceFolderWizard(existing, element, true, newFolder, newFolder, newFolder ? CPListElement.isProjectSourceFolder(existing, element.getJavaProject()) : false, newFolder);
        wizard.setDoFlushChange(false);
        return wizard;
    }

    private static EditFilterWizard newEditFilterWizard(CPListElement element, List existingElements, String outputLocation) {
        CPListElement[] existing = existingElements.toArray(new CPListElement[existingElements.size()]);
        EditFilterWizard result = new EditFilterWizard(existing, element);
        result.setDoFlushChange(false);
        return result;
    }

    public SourceContainerWorkbookPage(ListDialogField classPathList) {
        this.fClassPathList = classPathList;
        this.fSWTControl = null;
        SourceContainerAdapter adapter = new SourceContainerAdapter();
        String[] stringArray = new String[9];
        stringArray[0] = NewWizardMessages.SourceContainerWorkbookPage_folders_add_button;
        stringArray[1] = NewWizardMessages.SourceContainerWorkbookPage_folders_link_source_button;
        stringArray[3] = NewWizardMessages.LibrariesWorkbookPage_libraries_addextjar_button;
        stringArray[4] = NewWizardMessages.LibrariesWorkbookPage_libraries_addjar_button;
        stringArray[5] = NewWizardMessages.LibrariesWorkbookPage_libraries_addvariable_button;
        stringArray[7] = NewWizardMessages.SourceContainerWorkbookPage_folders_edit_button;
        stringArray[8] = NewWizardMessages.SourceContainerWorkbookPage_folders_remove_button;
        String[] buttonLabels = stringArray;
        this.fFoldersList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fFoldersList.setDialogFieldListener(adapter);
        this.fFoldersList.setLabelText(NewWizardMessages.SourceContainerWorkbookPage_folders_label);
        this.fFoldersList.setViewerComparator(new CPListElementSorter());
        this.fFoldersList.enableButton(7, false);
        this.fFoldersList.enableButton(5, false);
    }

    public void init(IJavaScriptProject jproject) {
        this.fCurrJProject = jproject;
        if (Display.getCurrent() != null) {
            this.updateFoldersList();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SourceContainerWorkbookPage.this.updateFoldersList();
                }
            });
        }
    }

    private void updateFoldersList() {
        CPListElement cpe;
        if (this.fSWTControl == null || this.fSWTControl.isDisposed()) {
            return;
        }
        ArrayList<CPListElement> folders = new ArrayList<CPListElement>();
        List cpelements = this.fClassPathList.getElements();
        int i = 0;
        while (i < cpelements.size()) {
            cpe = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                folders.add(cpe);
            }
            ++i;
        }
        this.fFoldersList.setElements(folders);
        i = 0;
        while (i < folders.size()) {
            cpe = (CPListElement)folders.get(i);
            IPath[] ePatterns = (IPath[])cpe.getAttribute("exclusion");
            IPath[] iPatterns = (IPath[])cpe.getAttribute("inclusion");
            if (ePatterns != null && iPatterns != null && (ePatterns.length > 0 || iPatterns.length > 0)) {
                this.fFoldersList.expandElement(cpe, 3);
            }
            ++i;
        }
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fFoldersList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fFoldersList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fFoldersList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        List elements = this.fFoldersList.getElements();
        int i = 0;
        while (i < elements.size()) {
            CPListElement elem = (CPListElement)elements.get(i);
            IPath[] exclusionPatterns = (IPath[])elem.getAttribute("exclusion");
            IPath[] inclusionPatterns = (IPath[])elem.getAttribute("inclusion");
            if (exclusionPatterns.length > 0 || inclusionPatterns.length > 0) {
                this.fFoldersList.expandElement(elem, 3);
            }
            ++i;
        }
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaScriptPlugin.getActiveWorkbenchShell();
    }

    protected void sourcePageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fFoldersList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    protected void sourcePageDoubleClicked(TreeListDialogField field) {
        List selection;
        if (field == this.fFoldersList && this.canEdit(selection = field.getSelectedElements())) {
            this.editEntry();
        }
    }

    protected void sourcePageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        if (field == this.fFoldersList) {
            if (index == 0) {
                IProject project = this.fCurrJProject.getProject();
                if (project.exists() && this.hasFolders((IContainer)project)) {
                    List existingElements = this.fFoldersList.getElements();
                    CPListElement[] existing = existingElements.toArray(new CPListElement[existingElements.size()]);
                    CreateMultipleSourceFoldersDialog dialog = new CreateMultipleSourceFoldersDialog(this.fCurrJProject, existing, "", this.getShell());
                    if (dialog.open() == 0) {
                        this.refresh(dialog.getInsertedElements(), dialog.getRemovedElements(), dialog.getModifiedElements());
                    }
                } else {
                    CPListElement newElement = new CPListElement(this.fCurrJProject, 3);
                    AddSourceFolderWizard wizard = SourceContainerWorkbookPage.newSourceFolderWizard(newElement, this.fFoldersList.getElements(), "", true);
                    OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
                    action.run();
                }
            } else if (index == 1) {
                CPListElement newElement = new CPListElement(this.fCurrJProject, 3);
                AddSourceFolderWizard wizard = SourceContainerWorkbookPage.newLinkedSourceFolderWizard(newElement, this.fFoldersList.getElements(), "", true);
                OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
                action.run();
            } else if (index == 4) {
                libentries = this.openJarFileDialog(null);
            } else if (index == 3) {
                libentries = this.openExtJarFileDialog(null);
            } else if (index == 7) {
                this.editEntry();
            } else if (index == 8) {
                this.removeEntry();
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fClassPathList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                    curr.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(curr));
                }
                ++i;
            }
            this.refresh(elementsToAdd, null, null);
            this.fClassPathList.addElements(elementsToAdd);
            this.fClassPathList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    private CPListElement[] openJarFileDialog(CPListElement existing) {
        IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseJAREntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedJARFiles(existing));
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    IPath curr = selected[i];
                    IResource resource = root.findMember(curr);
                    if (resource instanceof IFile) {
                        res.add(this.newCPLibraryElement(resource));
                    }
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IResource resource;
            IPath configured = BuildPathDialogAccess.configureJAREntry(this.getShell(), existing.getPath(), this.getUsedJARFiles(existing));
            if (configured != null && (resource = root.findMember(configured)) instanceof IFile) {
                return new CPListElement[]{this.newCPLibraryElement(resource)};
            }
        }
        return null;
    }

    private CPListElement[] openExtJarFileDialog(CPListElement existing) {
        CPListElement tempElem = null;
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries(this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    tempElem = new CPListElement(this.fCurrJProject, 1, selected[i], null);
                    tempElem.setExported(true);
                    res.add(tempElem);
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPath configured = BuildPathDialogAccess.configureExternalJAREntry(this.getShell(), existing.getPath());
            if (configured != null) {
                tempElem = new CPListElement(this.fCurrJProject, 1, configured, null);
                tempElem.setExported(true);
                return new CPListElement[]{tempElem};
            }
        }
        return null;
    }

    private IPath[] getUsedJARFiles(CPListElement existing) {
        ArrayList<Object> res = new ArrayList<Object>();
        List cplist = this.fFoldersList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing) {
                IResource resource = elem.getResource();
                if (resource instanceof IFile) {
                    res.add(resource.getFullPath());
                } else if (resource instanceof IPath) {
                    res.add(resource);
                }
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private CPListElement newCPLibraryElement(IResource res) {
        CPListElement elem = new CPListElement(this.fCurrJProject, 1, res.getFullPath(), res);
        elem.setExported(true);
        return elem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFolders(IContainer container) {
        List elements;
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IContainer) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        if ((elements = this.fFoldersList.getElements()).size() > 1) {
            return true;
        }
        if (elements.size() == 0) {
            return false;
        }
        CPListElement single = (CPListElement)elements.get(0);
        return !single.getPath().equals((Object)this.fCurrJProject.getPath());
    }

    private void editEntry() {
        List selElements = this.fFoldersList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fFoldersList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editElementEntry(CPListElement elem) {
        OpenBuildPathWizardAction action;
        AddSourceFolderWizard wizard;
        CPListElement[] res = null;
        if (elem.getEntryKind() == 5) {
            res = this.openContainerSelectionDialog(elem);
        } else if (elem.getEntryKind() == 1) {
            IResource resource = elem.getResource();
            if (resource == null) {
                res = this.openExtJarFileDialog(elem);
            } else if (resource.getType() == 2) {
                res = resource.exists() ? this.openClassFolderDialog(elem) : this.openNewClassFolderDialog(elem);
            } else if (resource.getType() == 1) {
                res = this.openJarFileDialog(elem);
            }
        }
        if (elem.getLinkTarget() != null) {
            wizard = SourceContainerWorkbookPage.newLinkedSourceFolderWizard(elem, this.fFoldersList.getElements(), "", false);
            action = new OpenBuildPathWizardAction(wizard);
            action.run();
        } else {
            wizard = SourceContainerWorkbookPage.newSourceFolderWizard(elem, this.fFoldersList.getElements(), "", false);
            action = new OpenBuildPathWizardAction(wizard);
            action.run();
        }
        if (res != null && res.length > 0) {
            CPListElement curr = res[0];
            curr.setExported(elem.isExported());
            curr.setAttributesFromExisting(elem);
            ArrayList<CPListElement> removed = new ArrayList<CPListElement>(0);
            ArrayList<CPListElement> added = new ArrayList<CPListElement>(0);
            removed.add(curr);
            added.add(elem);
            this.refresh(added, removed, null);
        }
    }

    private CPListElement[] openNewClassFolderDialog(CPListElement existing) {
        String title = existing == null ? NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_new_title : NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_edit_title;
        IProject currProject = this.fCurrJProject.getProject();
        NewContainerDialog dialog = new NewContainerDialog(this.getShell(), title, currProject, this.getUsedContainers(existing), existing);
        IPath projpath = currProject.getFullPath();
        dialog.setMessage(Messages.format(NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_description, projpath.toString()));
        if (dialog.open() == 0) {
            IFolder folder = dialog.getFolder();
            return new CPListElement[]{this.newCPLibraryElement((IResource)folder)};
        }
        return null;
    }

    private IPath[] getUsedContainers(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fFoldersList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private CPListElement[] openClassFolderDialog(CPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = BuildPathDialogAccess.chooseClassFolderEntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedContainers(existing))) != null) {
            IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = root.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(this.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement existing) {
        if (existing == null) {
            IIncludePathEntry[] created = BuildPathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrJProject, this.getRawClasspath());
            if (created != null) {
                CPListElement[] res = new CPListElement[created.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = new CPListElement(this.fCurrJProject, 5, created[i].getPath(), null);
                    ++i;
                }
                return res;
            }
        } else {
            IIncludePathEntry created = BuildPathDialogAccess.configureContainerEntry(this.getShell(), existing.getClasspathEntry(), this.fCurrJProject, this.getRawClasspath());
            if (created != null) {
                CPListElement elem = new CPListElement(this.fCurrJProject, 5, created.getPath(), null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private IIncludePathEntry[] getRawClasspath() {
        IIncludePathEntry[] currEntries = new IIncludePathEntry[this.fClassPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPListElement curr = (CPListElement)this.fClassPathList.getElement(i);
            currEntries[i] = curr.getClasspathEntry();
            ++i;
        }
        return currEntries;
    }

    private void attributeUpdated(CPListElement selElement, String[] changedAttributes) {
        Object parentContainer = selElement.getParentContainer();
        if (parentContainer instanceof CPListElement) {
            IIncludePathEntry updatedEntry = selElement.getClasspathEntry();
            this.updateContainerEntry(updatedEntry, changedAttributes, this.fCurrJProject, ((CPListElement)parentContainer).getPath());
        }
    }

    private void updateContainerEntry(final IIncludePathEntry newEntry, final String[] changedAttributes, final IJavaScriptProject jproject, final IPath containerPath) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BuildPathSupport.modifyClasspathEntry(null, newEntry, changedAttributes, jproject, containerPath, monitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_title;
            String message = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        CPListElement selElement = elem.getParent();
        if (key.equals("accessrules")) {
            AccessRulesDialog dialog = new AccessRulesDialog(this.getShell(), selElement, this.fCurrJProject, false);
            int res = dialog.open();
            if (res == 0 || res == 10) {
                selElement.setAttribute("accessrules", dialog.getAccessRules());
                String[] changedAttributes = new String[]{"accessrules"};
                this.attributeUpdated(selElement, changedAttributes);
                this.fFoldersList.refresh(elem);
                this.fClassPathList.dialogFieldChanged();
                this.updateEnabledState();
            }
        } else if (key.equals("exclusion") || key.equals("inclusion")) {
            EditFilterWizard wizard = SourceContainerWorkbookPage.newEditFilterWizard(elem.getParent(), this.fFoldersList.getElements(), "");
            OpenBuildPathWizardAction action = new OpenBuildPathWizardAction(wizard);
            action.run();
        } else if (this.editCustomAttribute(this.getShell(), elem)) {
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        }
    }

    protected void sourcePageSelectionChanged(DialogField field) {
        List selected = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(7, this.canEdit(selected));
        this.fFoldersList.enableButton(8, this.canRemove(selected));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selected);
        this.fFoldersList.enableButton(0, noAttributes);
    }

    private void removeEntry() {
        List selElements = this.fFoldersList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                if (attrib.isBuiltIn()) {
                    Path[] value = null;
                    if (key.equals("exclusion") || key.equals("inclusion")) {
                        value = new Path[]{};
                    }
                    attrib.getParent().setAttribute(key, value);
                } else {
                    this.removeCustomAttribute(attrib);
                }
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fFoldersList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            Iterator iter = selElements.iterator();
            while (iter.hasNext()) {
                CPListElement element = (CPListElement)iter.next();
                if (element.getEntryKind() != 3) continue;
                List list = ClasspathModifier.removeFilters(element.getPath(), this.fCurrJProject, this.fFoldersList.getElements());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    CPListElement modified = (CPListElement)iterator.next();
                    this.fFoldersList.refresh(modified);
                    this.fFoldersList.expandElement(modified, 3);
                }
            }
            this.fFoldersList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPListElement curr;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                if (attrib.isBuiltIn() ? ("inclusion".equals(key) ? ((IPath[])attrib.getValue()).length == 0 : ("exclusion".equals(key) ? ((IPath[])attrib.getValue()).length == 0 : attrib.getValue() == null)) : !this.canRemoveCustomAttribute(attrib)) {
                    return false;
                }
            } else if (elem instanceof CPListElement && (curr = (CPListElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            CPListElement cp = (CPListElement)elem;
            return !cp.getPath().equals((Object)cp.getJavaProject().getPath());
        }
        if (elem instanceof CPListElementAttribute) {
            CPListElementAttribute attrib = (CPListElementAttribute)elem;
            if (attrib.isBuiltIn()) {
                return true;
            }
            return this.canEditCustomAttribute(attrib);
        }
        return false;
    }

    private void sourcePageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject == null) {
            return;
        }
        if (field == this.fFoldersList) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int nEntries;
        List srcelements = this.fFoldersList.getElements();
        List cpelements = this.fClassPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int afterLastSourcePos = 0;
        int i = nEntries - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind)) {
                if (!srcelements.remove(cpe)) {
                    cpelements.remove(i);
                    lastRemovePos = i;
                } else if (lastRemovePos == nEntries) {
                    afterLastSourcePos = i + 1;
                }
            }
            --i;
        }
        if (!srcelements.isEmpty()) {
            int insertPos = Math.min(afterLastSourcePos, lastRemovePos);
            cpelements.addAll(insertPos, srcelements);
        }
        this.fClassPathList.setElements(cpelements);
    }

    public List getSelection() {
        return this.fFoldersList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fFoldersList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fFoldersList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    public boolean isEntryKind(int kind) {
        return kind == 3 || kind == 1 || kind == 4;
    }

    private void refresh(List insertedElements, List removedElements, List modifiedElements) {
        CPListElement element;
        if (removedElements == null) {
            removedElements = new ArrayList();
        }
        if (modifiedElements == null) {
            modifiedElements = new ArrayList();
        }
        this.fFoldersList.addElements(insertedElements);
        Iterator iter = insertedElements.iterator();
        while (iter.hasNext()) {
            element = (CPListElement)iter.next();
            this.fFoldersList.expandElement(element, 3);
        }
        this.fFoldersList.removeElements(removedElements);
        iter = modifiedElements.iterator();
        while (iter.hasNext()) {
            element = (CPListElement)iter.next();
            this.fFoldersList.refresh(element);
            this.fFoldersList.expandElement(element, 3);
            this.fFoldersList.dialogFieldChanged();
        }
        this.fFoldersList.refresh();
        if (!insertedElements.isEmpty()) {
            this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(insertedElements));
        }
    }

    private void updateEnabledState() {
        List selElements = this.fFoldersList.getSelectedElements();
        this.fFoldersList.enableButton(7, this.canEdit(selElements));
        this.fFoldersList.enableButton(8, this.canRemove(selElements));
    }

    public void setFocus() {
        this.fFoldersList.setFocus();
    }

    private class OpenBuildPathWizardAction
    extends AbstractOpenWizardAction
    implements IPropertyChangeListener {
        private final BuildPathWizard fWizard;
        private final List fSelectedElements;

        public OpenBuildPathWizardAction(BuildPathWizard wizard) {
            this.fWizard = wizard;
            this.addPropertyChangeListener(this);
            this.fSelectedElements = SourceContainerWorkbookPage.this.fFoldersList.getSelectedElements();
        }

        protected INewWizard createWizard() throws CoreException {
            return this.fWizard;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("result")) {
                if (event.getNewValue().equals(Boolean.TRUE)) {
                    this.finishWizard();
                } else {
                    this.fWizard.cancel();
                }
            }
        }

        protected void finishWizard() {
            List insertedElements = this.fWizard.getInsertedElements();
            SourceContainerWorkbookPage.this.refresh(insertedElements, this.fWizard.getRemovedElements(), this.fWizard.getModifiedElements());
            if (insertedElements.isEmpty()) {
                SourceContainerWorkbookPage.this.fFoldersList.postSetSelection((ISelection)new StructuredSelection(this.fSelectedElements));
            }
        }
    }

    private class SourceContainerAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] EMPTY_ARR = new Object[0];

        private SourceContainerAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            SourceContainerWorkbookPage.this.sourcePageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            SourceContainerWorkbookPage.this.sourcePageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            SourceContainerWorkbookPage.this.sourcePageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            SourceContainerWorkbookPage.this.sourcePageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element instanceof CPListElement;
        }

        public void dialogFieldChanged(DialogField field) {
            SourceContainerWorkbookPage.this.sourcePageDialogFieldChanged(field);
        }
    }
}

