/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.MethodsViewer;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class MethodsLabelProvider
extends AppearanceAwareLabelProvider {
    private boolean fShowDefiningType;
    private TypeHierarchyLifeCycle fHierarchy;
    private MethodsViewer fMethodsViewer;
    private IPropertyChangeListener fColorRegistryListener;

    public MethodsLabelProvider(TypeHierarchyLifeCycle lifeCycle, MethodsViewer methodsViewer) {
        super(36283885813802L, 1);
        this.fHierarchy = lifeCycle;
        this.fShowDefiningType = false;
        this.fMethodsViewer = methodsViewer;
        this.fColorRegistryListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.wst.jsdt.ui.ColoredLabels.inherited")) {
                    MethodsLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)MethodsLabelProvider.this, null));
                }
            }
        };
        JFaceResources.getColorRegistry().addListener(this.fColorRegistryListener);
    }

    public void setShowDefiningType(boolean showDefiningType) {
        this.fShowDefiningType = showDefiningType;
    }

    public boolean isShowDefiningType() {
        return this.fShowDefiningType;
    }

    private IType getDefiningType(Object element) throws JavaScriptModelException {
        int kind = ((IJavaScriptElement)element).getElementType();
        if (kind != 9 && kind != 8 && kind != 10) {
            return null;
        }
        IType declaringType = ((IMember)element).getDeclaringType();
        if (kind != 9) {
            return declaringType;
        }
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return declaringType;
        }
        MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
        IFunction method = (IFunction)element;
        IFunction res = tester.findDeclaringMethod(method, true);
        if (res == null || method.equals(res)) {
            return declaringType;
        }
        return res.getDeclaringType();
    }

    public String getText(Object element) {
        String text = super.getText(element);
        String qualifier = this.getQualifier(element);
        if (qualifier != null) {
            return String.valueOf(qualifier) + text;
        }
        return text;
    }

    public ColoredString getRichTextLabel(Object element) {
        ColoredString text = super.getRichTextLabel(element);
        String qualifier = this.getQualifier(element);
        if (qualifier != null) {
            return new ColoredString(qualifier).append(text);
        }
        return text;
    }

    private String getQualifier(Object element) {
        if (this.fShowDefiningType) {
            try {
                IType type = this.getDefiningType(element);
                if (type != null) {
                    return String.valueOf(super.getText(type)) + JavaScriptElementLabels.CONCAT_STRING;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return null;
    }

    public Color getForeground(Object element) {
        IFunction curr;
        IType declaringType;
        if (this.fMethodsViewer.isShowInheritedMethods() && element instanceof IFunction && ((declaringType = (curr = (IFunction)element).getDeclaringType()) == null || !declaringType.equals(this.fMethodsViewer.getInput()))) {
            return JFaceResources.getColorRegistry().get("org.eclipse.wst.jsdt.ui.ColoredLabels.inherited");
        }
        return null;
    }

    public void dispose() {
        JFaceResources.getColorRegistry().removeListener(this.fColorRegistryListener);
        this.fColorRegistryListener = null;
        super.dispose();
    }
}

