/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.jsdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.wst.jsdt.internal.ui.text.CombinedWordRule;
import org.eclipse.wst.jsdt.internal.ui.text.ISourceVersionDependent;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWhitespaceDetector;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordDetector;
import org.eclipse.wst.jsdt.ui.text.IColorManager;

public final class JavaCodeScanner
extends AbstractJavaScanner {
    private static final String SOURCE_VERSION = "org.eclipse.wst.jsdt.core.compiler.source";
    static String[] fgKeywords = new String[]{"abstract", "break", "case", "catch", "class", "const", "continue", "default", "delete", "debugger", "do", "else", "export", "extends", "final", "finally", "for", "function", "goto", "if", "implements", "in", "instanceof", "interface", "new", "package", "private", "protected", "public", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "typeof", "var", "volatile", "while", "with"};
    private static final String RETURN = "return";
    private static String[] fgJava14Keywords = new String[0];
    private static String[] fgJava15Keywords = new String[]{"enum"};
    private static String[] fgTypes = new String[0];
    private static String[] fgConstants = new String[]{"false", "null", "true", "undefined"};
    private static final String ANNOTATION_BASE_KEY = "semanticHighlighting.annotation";
    private static final String ANNOTATION_COLOR_KEY = "semanticHighlighting.annotation.color";
    private static String[] fgTokenProperties = new String[]{"java_keyword", "java_string", "java_default", "java_keyword_return", "java_operator", "java_bracket", "semanticHighlighting.annotation.color"};
    private List fVersionDependentRules = new ArrayList(3);

    public JavaCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token token = this.getToken("java_string");
        rules.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new JavaWhitespaceDetector()));
        String version = this.getPreferenceStore().getString(SOURCE_VERSION);
        JavaWordDetector wordDetector = new JavaWordDetector();
        token = this.getToken("java_default");
        CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)wordDetector, (IToken)token);
        token = this.getToken("java_default");
        VersionedWordMatcher j14Matcher = new VersionedWordMatcher((IToken)token, "1.4", version);
        token = this.getToken("java_keyword");
        int i = 0;
        while (i < fgJava14Keywords.length) {
            j14Matcher.addWord(fgJava14Keywords[i], (IToken)token);
            ++i;
        }
        combinedWordRule.addWordMatcher(j14Matcher);
        this.fVersionDependentRules.add(j14Matcher);
        token = this.getToken("java_default");
        VersionedWordMatcher j15Matcher = new VersionedWordMatcher((IToken)token, "1.5", version);
        token = this.getToken("java_keyword");
        int i2 = 0;
        while (i2 < fgJava15Keywords.length) {
            j15Matcher.addWord(fgJava15Keywords[i2], (IToken)token);
            ++i2;
        }
        combinedWordRule.addWordMatcher(j15Matcher);
        this.fVersionDependentRules.add(j15Matcher);
        token = this.getToken("java_operator");
        rules.add(new OperatorRule((IToken)token));
        token = this.getToken("java_bracket");
        rules.add(new BracketRule((IToken)token));
        CombinedWordRule.WordMatcher returnWordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken("java_keyword_return");
        returnWordRule.addWord(RETURN, (IToken)token);
        combinedWordRule.addWordMatcher(returnWordRule);
        CombinedWordRule.WordMatcher wordRule = new CombinedWordRule.WordMatcher();
        token = this.getToken("java_keyword");
        int i3 = 0;
        while (i3 < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i3], (IToken)token);
            ++i3;
        }
        i3 = 0;
        while (i3 < fgTypes.length) {
            wordRule.addWord(fgTypes[i3], (IToken)token);
            ++i3;
        }
        i3 = 0;
        while (i3 < fgConstants.length) {
            wordRule.addWord(fgConstants[i3], (IToken)token);
            ++i3;
        }
        combinedWordRule.addWordMatcher(wordRule);
        rules.add(combinedWordRule);
        this.setDefaultReturnToken((IToken)this.getToken("java_default"));
        return rules;
    }

    protected String getBoldKey(String colorKey) {
        if (ANNOTATION_COLOR_KEY.equals(colorKey)) {
            return "semanticHighlighting.annotation.bold";
        }
        return super.getBoldKey(colorKey);
    }

    protected String getItalicKey(String colorKey) {
        if (ANNOTATION_COLOR_KEY.equals(colorKey)) {
            return "semanticHighlighting.annotation.italic";
        }
        return super.getItalicKey(colorKey);
    }

    protected String getStrikethroughKey(String colorKey) {
        if (ANNOTATION_COLOR_KEY.equals(colorKey)) {
            return "semanticHighlighting.annotation.strikethrough";
        }
        return super.getStrikethroughKey(colorKey);
    }

    protected String getUnderlineKey(String colorKey) {
        if (ANNOTATION_COLOR_KEY.equals(colorKey)) {
            return "semanticHighlighting.annotation.underline";
        }
        return super.getUnderlineKey(colorKey);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals(SOURCE_VERSION) || super.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(SOURCE_VERSION)) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                String s = (String)value;
                Iterator it = this.fVersionDependentRules.iterator();
                while (it.hasNext()) {
                    ISourceVersionDependent dependent = (ISourceVersionDependent)it.next();
                    dependent.setSourceVersion(s);
                }
            }
        } else if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    private static final class BracketRule
    implements IRule {
        private final char[] JAVA_BRACKETS = new char[]{'(', ')', '{', '}', '[', ']'};
        private final IToken fToken;

        public BracketRule(IToken token) {
            this.fToken = token;
        }

        public boolean isBracket(char character) {
            int index = 0;
            while (index < this.JAVA_BRACKETS.length) {
                if (this.JAVA_BRACKETS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isBracket((char)character)) {
                while (this.isBracket((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static final class OperatorRule
    implements IRule {
        private final char[] JAVA_OPERATORS = new char[]{';', '.', '=', '/', '\\', '+', '-', '*', '<', '>', ':', '?', '!', ',', '|', '&', '^', '%', '~'};
        private final IToken fToken;

        public OperatorRule(IToken token) {
            this.fToken = token;
        }

        public boolean isOperator(char character) {
            int index = 0;
            while (index < this.JAVA_OPERATORS.length) {
                if (this.JAVA_OPERATORS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isOperator((char)character)) {
                while (this.isOperator((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static class VersionedWordMatcher
    extends CombinedWordRule.WordMatcher
    implements ISourceVersionDependent {
        private final IToken fDefaultToken;
        private final String fVersion;
        private boolean fIsVersionMatch;

        public VersionedWordMatcher(IToken defaultToken, String version, String currentVersion) {
            this.fDefaultToken = defaultToken;
            this.fVersion = version;
            this.setSourceVersion(currentVersion);
        }

        public void setSourceVersion(String version) {
            this.fIsVersionMatch = this.fVersion.compareTo(version) <= 0;
        }

        public IToken evaluate(ICharacterScanner scanner, CombinedWordRule.CharacterBuffer word) {
            IToken token = super.evaluate(scanner, word);
            if (this.fIsVersionMatch || token.isUndefined()) {
                return token;
            }
            return this.fDefaultToken;
        }
    }
}

