/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;

class ChangeTypeContentProvider
implements ITreeContentProvider {
    private ChangeTypeRefactoring fGeneralizeType;

    ChangeTypeContentProvider(ChangeTypeRefactoring gt) {
        this.fGeneralizeType = gt;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof RootType) {
            return ((RootType)element).getChildren();
        }
        Object[] superTypes = this.getDirectSuperTypes((ITypeBinding)element).toArray();
        Arrays.sort(superTypes, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((ITypeBinding)o1).getQualifiedName();
                String name2 = ((ITypeBinding)o2).getQualifiedName();
                return name1.compareTo(name2);
            }
        });
        return superTypes;
    }

    public Set getDirectSuperTypes(ITypeBinding type) {
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        if (type.getSuperclass() != null) {
            result.add(type.getSuperclass());
        }
        return result;
    }

    public Object[] getElements(Object element) {
        Assert.isTrue((boolean)(element instanceof RootType));
        return ((RootType)element).getChildren();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object getParent(Object element) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    static class RootType {
        private ITypeBinding fRoot;

        RootType(ITypeBinding root) {
            this.fRoot = root;
        }

        public ITypeBinding[] getChildren() {
            return new ITypeBinding[]{this.fRoot};
        }
    }
}

