/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;

public class JdtFlags {
    public static final String VISIBILITY_STRING_PRIVATE = "private";
    public static final String VISIBILITY_STRING_PACKAGE = "";
    public static final String VISIBILITY_STRING_PROTECTED = "protected";
    public static final String VISIBILITY_STRING_PUBLIC = "public";
    public static final int VISIBILITY_CODE_INVALID = -1;

    private JdtFlags() {
    }

    public static boolean isAbstract(IMember member) throws JavaScriptModelException {
        return Flags.isAbstract((int)member.getFlags());
    }

    public static boolean isAbstract(IFunctionBinding member) {
        return Modifier.isAbstract((int)member.getModifiers());
    }

    public static boolean isDeprecated(IMember member) throws JavaScriptModelException {
        return Flags.isDeprecated((int)member.getFlags());
    }

    public static boolean isFinal(IMember member) throws JavaScriptModelException {
        return JdtFlags.isAnonymousType(member);
    }

    public static boolean isPackageVisible(IMember member) throws JavaScriptModelException {
        return !JdtFlags.isPrivate(member) && !JdtFlags.isPublic(member);
    }

    public static boolean isPackageVisible(BodyDeclaration bodyDeclaration) {
        return !JdtFlags.isPrivate(bodyDeclaration) && !JdtFlags.isProtected(bodyDeclaration) && !JdtFlags.isPublic(bodyDeclaration);
    }

    public static boolean isPackageVisible(IBinding binding) {
        return !JdtFlags.isPrivate(binding) && !JdtFlags.isProtected(binding) && !JdtFlags.isPublic(binding);
    }

    public static boolean isPrivate(IMember member) throws JavaScriptModelException {
        return Flags.isPrivate((int)member.getFlags());
    }

    public static boolean isPrivate(BodyDeclaration bodyDeclaration) {
        return Modifier.isPrivate((int)bodyDeclaration.getModifiers());
    }

    public static boolean isPrivate(IBinding binding) {
        return Modifier.isPrivate((int)binding.getModifiers());
    }

    public static boolean isProtected(BodyDeclaration bodyDeclaration) {
        return Modifier.isProtected((int)bodyDeclaration.getModifiers());
    }

    public static boolean isProtected(IBinding binding) {
        return Modifier.isProtected((int)binding.getModifiers());
    }

    public static boolean isPublic(IMember member) throws JavaScriptModelException {
        return Flags.isPublic((int)member.getFlags());
    }

    public static boolean isPublic(IBinding binding) {
        return Modifier.isPublic((int)binding.getModifiers());
    }

    public static boolean isPublic(BodyDeclaration bodyDeclaration) {
        return Modifier.isPublic((int)bodyDeclaration.getModifiers());
    }

    public static boolean isStatic(IMember member) throws JavaScriptModelException {
        return Flags.isStatic((int)member.getFlags());
    }

    public static boolean isStatic(IFunctionBinding methodBinding) {
        return Modifier.isStatic((int)methodBinding.getModifiers());
    }

    public static boolean isStatic(IVariableBinding variableBinding) {
        return Modifier.isStatic((int)variableBinding.getModifiers());
    }

    public static boolean isVarargs(IFunction method) throws JavaScriptModelException {
        return Flags.isVarargs((int)method.getFlags());
    }

    private static boolean isAnonymousType(IMember member) throws JavaScriptModelException {
        return member.getElementType() == 7 && ((IType)member).isAnonymous();
    }

    public static int getVisibilityCode(IMember member) throws JavaScriptModelException {
        if (JdtFlags.isPublic(member)) {
            return 1;
        }
        if (JdtFlags.isPackageVisible(member)) {
            return 0;
        }
        if (JdtFlags.isPrivate(member)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    public static int getVisibilityCode(BodyDeclaration bodyDeclaration) {
        if (JdtFlags.isPublic(bodyDeclaration)) {
            return 1;
        }
        if (JdtFlags.isProtected(bodyDeclaration)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(bodyDeclaration)) {
            return 0;
        }
        if (JdtFlags.isPrivate(bodyDeclaration)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    public static int getVisibilityCode(IBinding binding) {
        if (JdtFlags.isPublic(binding)) {
            return 1;
        }
        if (JdtFlags.isProtected(binding)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(binding)) {
            return 0;
        }
        if (JdtFlags.isPrivate(binding)) {
            return 2;
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    public static String getVisibilityString(int visibilityCode) {
        if (Modifier.isPublic((int)visibilityCode)) {
            return VISIBILITY_STRING_PUBLIC;
        }
        if (Modifier.isProtected((int)visibilityCode)) {
            return VISIBILITY_STRING_PROTECTED;
        }
        if (Modifier.isPrivate((int)visibilityCode)) {
            return VISIBILITY_STRING_PRIVATE;
        }
        return VISIBILITY_STRING_PACKAGE;
    }

    public static int getVisibilityCode(String visibilityString) {
        Assert.isNotNull((Object)visibilityString);
        if (VISIBILITY_STRING_PACKAGE.equals(visibilityString)) {
            return 0;
        }
        if (VISIBILITY_STRING_PRIVATE.equals(visibilityString)) {
            return 2;
        }
        if (VISIBILITY_STRING_PROTECTED.equals(visibilityString)) {
            return 4;
        }
        if (VISIBILITY_STRING_PUBLIC.equals(visibilityString)) {
            return 1;
        }
        return -1;
    }

    public static void assertVisibility(int visibility) {
        Assert.isTrue((visibility == 1 || visibility == 4 || visibility == 0 || visibility == 2 ? 1 : 0) != 0);
    }

    public static boolean isHigherVisibility(int newVisibility, int oldVisibility) {
        JdtFlags.assertVisibility(oldVisibility);
        JdtFlags.assertVisibility(newVisibility);
        switch (oldVisibility) {
            case 2: {
                return newVisibility == 0 || newVisibility == 1 || newVisibility == 4;
            }
            case 0: {
                return newVisibility == 1 || newVisibility == 4;
            }
            case 4: {
                return newVisibility == 1;
            }
            case 1: {
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    public static int getLowerVisibility(int visibility1, int visibility2) {
        if (JdtFlags.isHigherVisibility(visibility1, visibility2)) {
            return visibility2;
        }
        return visibility1;
    }

    public static int clearAccessModifiers(int flags) {
        return JdtFlags.clearFlag(7, flags);
    }

    public static int clearFlag(int flag, int flags) {
        return flags & ~flag;
    }
}

