/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;

public class QualifiedNameSearchResult {
    private Map fChanges = new HashMap();

    public TextChange getChange(IFile file) {
        TextChange result = (TextChange)this.fChanges.get(file);
        if (result == null) {
            result = new TextFileChange(file.getName(), file);
            this.fChanges.put(file, result);
        }
        return result;
    }

    public TextChange[] getAllChanges() {
        Collection values = this.fChanges.values();
        return values.toArray(new TextChange[values.size()]);
    }

    public IFile[] getAllFiles() {
        Set keys = this.fChanges.keySet();
        return keys.toArray(new IFile[keys.size()]);
    }

    public Change getSingleChange(IFile[] alreadyTouchedFiles) {
        Collection values = this.fChanges.values();
        if (values.size() == 0) {
            return null;
        }
        CompositeChange result = new CompositeChange(RefactoringCoreMessages.QualifiedNameSearchResult_change_name);
        result.markAsSynthetic();
        List<IFile> files = Arrays.asList(alreadyTouchedFiles);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            TextFileChange change = (TextFileChange)iter.next();
            if (files.contains(change.getFile())) continue;
            result.add((Change)change);
        }
        return result;
    }
}

