/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.delegates;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateCreator;

public class DelegateMethodCreator
extends DelegateCreator {
    private ASTNode fDelegateInvocation;
    private FunctionRef fDocMethodReference;

    protected void initialize() {
        Assert.isTrue((boolean)(this.getDeclaration() instanceof FunctionDeclaration));
        if (this.getNewElementName() == null) {
            this.setNewElementName(((FunctionDeclaration)this.getDeclaration()).getName().getIdentifier());
        }
        this.setInsertBefore(true);
    }

    protected ASTNode createBody(BodyDeclaration bd) throws JavaScriptModelException {
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)bd;
        if (methodDeclaration.getBody() == null) {
            return null;
        }
        return this.createDelegateMethodBody(methodDeclaration);
    }

    protected ASTNode createDocReference(BodyDeclaration declaration) throws JavaScriptModelException {
        this.fDocMethodReference = this.getAst().newFunctionRef();
        this.fDocMethodReference.setName(this.getAst().newSimpleName(this.getNewElementName()));
        if (this.isMoveToAnotherFile()) {
            this.fDocMethodReference.setQualifier(this.createDestinationTypeName());
        }
        this.createArguments((FunctionDeclaration)declaration, this.fDocMethodReference.parameters(), false);
        return this.fDocMethodReference;
    }

    protected ASTNode getBodyHead(BodyDeclaration result) {
        return result;
    }

    protected ChildPropertyDescriptor getJavaDocProperty() {
        return FunctionDeclaration.JAVADOC_PROPERTY;
    }

    protected ChildPropertyDescriptor getBodyProperty() {
        return FunctionDeclaration.BODY_PROPERTY;
    }

    public ASTNode getDelegateInvocation() {
        return this.fDelegateInvocation;
    }

    public FunctionRef getJavadocReference() {
        return this.fDocMethodReference;
    }

    protected Statement createMethodInvocation(FunctionDeclaration declaration, FunctionInvocation invocation) {
        PrimitiveType primitive;
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)invocation);
        Object statement = null;
        Type type = declaration.getReturnType2();
        statement = type == null ? this.createExpressionStatement(invocation) : (type instanceof PrimitiveType ? ((primitive = (PrimitiveType)type).getPrimitiveTypeCode().equals(PrimitiveType.VOID) ? this.createExpressionStatement(invocation) : this.createReturnStatement(invocation)) : this.createReturnStatement(invocation));
        return statement;
    }

    protected IBinding getDeclarationBinding() {
        FunctionDeclaration declaration = (FunctionDeclaration)this.getDeclaration();
        return declaration.resolveBinding();
    }

    private void createArguments(FunctionDeclaration declaration, List arguments, boolean methodInvocation) throws JavaScriptModelException {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)arguments);
        SingleVariableDeclaration variable = null;
        int size = declaration.parameters().size();
        int index = 0;
        while (index < size) {
            variable = (SingleVariableDeclaration)declaration.parameters().get(index);
            if (methodInvocation) {
                SimpleName expression = this.getAst().newSimpleName(variable.getName().getIdentifier());
                arguments.add(expression);
            } else {
                FunctionRefParameter parameter = this.getAst().newFunctionRefParameter();
                parameter.setType(ASTNodeFactory.newType(this.getAst(), (VariableDeclaration)variable));
                if (index == size - 1 && declaration.isVarargs()) {
                    parameter.setVarargs(true);
                }
                arguments.add(parameter);
            }
            ++index;
        }
    }

    private Block createDelegateMethodBody(FunctionDeclaration declaration) throws JavaScriptModelException {
        ConstructorInvocation call;
        List arguments;
        ConstructorInvocation invocation;
        Assert.isNotNull((Object)declaration);
        FunctionDeclaration old = (FunctionDeclaration)this.getDeclaration();
        if (old.isConstructor()) {
            invocation = this.getAst().newConstructorInvocation();
            arguments = invocation.arguments();
            call = invocation;
            this.fDelegateInvocation = invocation;
        } else {
            invocation = this.getAst().newFunctionInvocation();
            invocation.setName(this.getAst().newSimpleName(this.getNewElementName()));
            invocation.setExpression(this.getAccess());
            arguments = invocation.arguments();
            call = this.createMethodInvocation(declaration, (FunctionInvocation)invocation);
            this.fDelegateInvocation = invocation;
        }
        this.createArguments(declaration, arguments, true);
        Block body = this.getAst().newBlock();
        body.statements().add(call);
        return body;
    }

    private ExpressionStatement createExpressionStatement(FunctionInvocation invocation) {
        Assert.isNotNull((Object)invocation);
        return invocation.getAST().newExpressionStatement((Expression)invocation);
    }

    private ReturnStatement createReturnStatement(FunctionInvocation invocation) {
        Assert.isNotNull((Object)invocation);
        ReturnStatement statement = invocation.getAST().newReturnStatement();
        statement.setExpression((Expression)invocation);
        return statement;
    }

    protected String getTextEditGroupLabel() {
        return RefactoringCoreMessages.DelegateMethodCreator_text_edit_group_field;
    }
}

