/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.BindingComparator;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.DefaultBindingResolver;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;

class VariableBinding
implements IVariableBinding {
    private static final int VALID_MODIFIERS = 223;
    private org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding binding;
    private ITypeBinding declaringClass;
    private String key;
    private String name;
    private BindingResolver resolver;
    private ITypeBinding type;

    VariableBinding(BindingResolver resolver, org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    public Object getConstantValue() {
        return null;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.isField()) {
            if (this.declaringClass == null) {
                FieldBinding fieldBinding = (FieldBinding)this.binding;
                this.declaringClass = this.resolver.getTypeBinding(fieldBinding.declaringClass);
            }
            return this.declaringClass;
        }
        return null;
    }

    public IFunctionBinding getDeclaringMethod() {
        if (!this.isField()) {
            for (ASTNode node = this.resolver.findDeclaringNode(this); node != null; node = node.getParent()) {
                switch (node.getNodeType()) {
                    case 28: {
                        return null;
                    }
                    case 31: {
                        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
                        return methodDeclaration.resolveBinding();
                    }
                }
            }
        }
        return null;
    }

    public IJavaScriptElement getJavaElement() {
        JavaElement element = this.getUnresolvedJavaElement();
        if (element == null) {
            return null;
        }
        return element.resolved(this.binding);
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public int getKind() {
        return 3;
    }

    public int getModifiers() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).getAccessFlags() & 0xDF;
        }
        return 0;
    }

    public String getName() {
        if (this.name == null) {
            this.name = new String(this.binding.name);
        }
        return this.name;
    }

    public ITypeBinding getType() {
        if (this.type == null) {
            this.type = this.resolver.getTypeBinding(this.binding.type);
        }
        return this.type;
    }

    private JavaElement getUnresolvedJavaElement() {
        int nameLength;
        int nameStart;
        int sourceLength;
        int sourceStart;
        if (this.isField()) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            if (fieldBinding.declaringClass == null) {
                return null;
            }
            IType declaringType = (IType)this.getDeclaringClass().getJavaElement();
            if (declaringType == null) {
                return null;
            }
            return (JavaElement)((Object)declaringType.getField(this.getName()));
        }
        IFunctionBinding declaringMethod = this.getDeclaringMethod();
        if (declaringMethod == null) {
            return null;
        }
        JavaElement method = (JavaElement)declaringMethod.getJavaElement();
        if (!(this.resolver instanceof DefaultBindingResolver)) {
            return null;
        }
        VariableDeclaration localVar = (VariableDeclaration)((DefaultBindingResolver)this.resolver).bindingsToAstNodes.get(this);
        if (localVar == null) {
            return null;
        }
        if (localVar instanceof SingleVariableDeclaration) {
            sourceStart = localVar.getStartPosition();
            sourceLength = localVar.getLength();
            SimpleName simpleName = ((SingleVariableDeclaration)localVar).getName();
            nameStart = simpleName.getStartPosition();
            nameLength = simpleName.getLength();
        } else {
            nameStart = localVar.getStartPosition();
            nameLength = localVar.getLength();
            ASTNode node = localVar.getParent();
            sourceStart = node.getStartPosition();
            sourceLength = node.getLength();
        }
        char[] typeSig = this.binding.type.signature();
        return new LocalVariable(method, localVar.getName().getIdentifier(), sourceStart, sourceStart + sourceLength - 1, nameStart, nameStart + nameLength - 1, new String(typeSig));
    }

    public IVariableBinding getVariableDeclaration() {
        if (this.isField()) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            return this.resolver.getVariableBinding(fieldBinding.original());
        }
        return this;
    }

    public int getVariableId() {
        return this.binding.id;
    }

    public boolean isParameter() {
        return (this.binding.tagBits & 0x400L) != 0L;
    }

    public boolean isDeprecated() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isDeprecated();
        }
        return false;
    }

    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof VariableBinding)) {
            return false;
        }
        org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding otherBinding = ((VariableBinding)other).binding;
        if (this.binding instanceof FieldBinding) {
            if (otherBinding instanceof FieldBinding) {
                return BindingComparator.isEqual((FieldBinding)this.binding, (FieldBinding)otherBinding);
            }
            return false;
        }
        if (BindingComparator.isEqual(this.binding, otherBinding)) {
            IFunctionBinding declaringMethod = this.getDeclaringMethod();
            IFunctionBinding otherDeclaringMethod = ((VariableBinding)other).getDeclaringMethod();
            if (declaringMethod == null) {
                return otherDeclaringMethod == null;
            }
            return declaringMethod.isEqualTo(otherDeclaringMethod);
        }
        return false;
    }

    public boolean isField() {
        return this.binding instanceof FieldBinding;
    }

    public boolean isGlobal() {
        return this.binding instanceof LocalVariableBinding && ((LocalVariableBinding)this.binding).declaringScope instanceof CompilationUnitScope;
    }

    public boolean isRecovered() {
        return false;
    }

    public String toString() {
        return this.binding.toString();
    }
}

