/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;

public class MultiElementListSelectionDialog
extends AbstractElementListSelectionDialog {
    private Page[] fPages;
    private int fCurrentPage;
    private int fNumberOfPages;
    private Button fFinishButton;
    private Button fBackButton;
    private Button fNextButton;
    private Label fPageInfoLabel;
    private String fPageInfoMessage = JavaUIMessages.MultiElementListSelectionDialog_pageInfoMessage;
    private Comparator fComparator;

    public MultiElementListSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent, renderer);
    }

    public void setPageInfoMessage(String message) {
        this.fPageInfoMessage = message;
    }

    public void setElements(Object[][] elements) {
        this.fNumberOfPages = elements.length;
        this.fPages = new Page[this.fNumberOfPages];
        int i = 0;
        while (i != this.fNumberOfPages) {
            this.fPages[i] = new Page(elements[i]);
            ++i;
        }
        this.initializeResult(this.fNumberOfPages);
    }

    public int open() {
        List selection = this.getInitialElementSelections();
        if (selection == null || selection.size() != this.fNumberOfPages) {
            this.setInitialSelections(new Object[this.fNumberOfPages]);
            selection = this.getInitialElementSelections();
        }
        Assert.isTrue((selection.size() == this.fNumberOfPages ? 1 : 0) != 0);
        return super.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.createFilteredList(contents);
        this.fCurrentPage = 0;
        this.setPageData();
        MultiElementListSelectionDialog.applyDialogFont((Control)contents);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fBackButton = this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
        this.fNextButton = this.createButton(parent, 15, IDialogConstants.NEXT_LABEL, true);
        this.fFinishButton = this.createButton(parent, 0, IDialogConstants.FINISH_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Label createMessageArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(256);
        composite.setLayoutData((Object)data);
        Label messageLabel = super.createMessageArea(composite);
        this.fPageInfoLabel = new Label(composite, 0);
        this.fPageInfoLabel.setText(this.getPageInfoMessage());
        data = new GridData(256);
        data.horizontalAlignment = 3;
        this.fPageInfoLabel.setLayoutData((Object)data);
        MultiElementListSelectionDialog.applyDialogFont((Control)messageLabel);
        return messageLabel;
    }

    protected void computeResult() {
        this.setResult(this.fCurrentPage, this.getSelectedElements());
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 14) {
            this.turnPage(false);
        } else if (buttonId == 15) {
            this.turnPage(true);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            if (this.fCurrentPage == this.fNumberOfPages - 1) {
                this.buttonPressed(0);
            } else {
                this.buttonPressed(15);
            }
        }
    }

    protected void updateButtonsEnableState(IStatus status) {
        boolean isOK;
        this.fPages[this.fCurrentPage].okState = isOK = !status.matches(4);
        boolean isAllOK = isOK;
        int i = 0;
        while (i != this.fNumberOfPages) {
            isAllOK = isAllOK && this.fPages[i].okState;
            ++i;
        }
        this.fFinishButton.setEnabled(isAllOK);
        boolean nextButtonEnabled = isOK && this.fCurrentPage < this.fNumberOfPages - 1;
        this.fNextButton.setEnabled(nextButtonEnabled);
        this.fBackButton.setEnabled(this.fCurrentPage != 0);
        if (nextButtonEnabled) {
            this.getShell().setDefaultButton(this.fNextButton);
        } else if (isAllOK) {
            this.getShell().setDefaultButton(this.fFinishButton);
        }
    }

    private void turnPage(boolean toNextPage) {
        Page page = this.fPages[this.fCurrentPage];
        String filter = this.getFilter();
        if (filter == null) {
            filter = "";
        }
        page.filter = filter;
        Object[] selectedElements = this.getSelectedElements();
        List list = this.getInitialElementSelections();
        list.set(this.fCurrentPage, selectedElements);
        this.setResult(this.fCurrentPage, this.getSelectedElements());
        if (toNextPage) {
            if (this.fCurrentPage + 1 >= this.fNumberOfPages) {
                return;
            }
            ++this.fCurrentPage;
        } else {
            if (this.fCurrentPage - 1 < 0) {
                return;
            }
            --this.fCurrentPage;
        }
        if (this.fPageInfoLabel != null && !this.fPageInfoLabel.isDisposed()) {
            this.fPageInfoLabel.setText(this.getPageInfoMessage());
        }
        this.setPageData();
        this.validateCurrentSelection();
    }

    private void setPageData() {
        Page page = this.fPages[this.fCurrentPage];
        this.setListElements(page.elements);
        String filter = page.filter;
        if (filter == null) {
            filter = "";
        }
        this.setFilter(filter);
        Object[] selectedElements = (Object[])this.getInitialElementSelections().get(this.fCurrentPage);
        this.setSelection(selectedElements);
        this.fFilteredList.setFocus();
    }

    private String getPageInfoMessage() {
        if (this.fPageInfoMessage == null) {
            return "";
        }
        Object[] args = new String[]{Integer.toString(this.fCurrentPage + 1), Integer.toString(this.fNumberOfPages)};
        return Messages.format(this.fPageInfoMessage, args);
    }

    private void initializeResult(int length) {
        ArrayList<Object> result = new ArrayList<Object>(length);
        int i = 0;
        while (i != length) {
            result.add(null);
            ++i;
        }
        this.setResult(result);
    }

    public int getCurrentPage() {
        return this.fCurrentPage;
    }

    public void setComparator(Comparator comparator) {
        this.fComparator = comparator;
        if (this.fFilteredList != null) {
            this.fFilteredList.setComparator(this.fComparator);
        }
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList filteredList = super.createFilteredList(parent);
        if (this.fComparator != null) {
            filteredList.setComparator(this.fComparator);
        }
        return filteredList;
    }

    private static class Page {
        private Object[] elements;
        public String filter;
        public boolean okState = false;

        public Page(Object[] elements) {
            this.elements = elements;
        }
    }
}

