/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetCreationWizardPage;

public abstract class J2EEImportPage
extends DataModelWizardPage {
    private Combo componentCombo;
    private Combo fileNameCombo;
    private static final String STORE_LABEL = "J2EE_IMPORT_";
    private static final int SIZING_TEXT_FIELD_WIDTH = 305;
    protected static final String defBrowseButtonLabel = J2EEUIMessages.getResourceString("93");

    public J2EEImportPage(IDataModel model, String pageName) {
        super(model, pageName);
    }

    protected String[] getValidationPropertyNames() {
        return null;
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createFileNameComposite(composite);
        this.createProjectNameComposite(composite);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void createProjectNameComposite(Composite parent) {
        Label componentLabel = new Label(parent, 0);
        componentLabel.setText(this.getProjectImportLabel());
        componentLabel.setLayoutData((Object)new GridData(32));
        this.componentCombo = new Combo(parent, 2052);
        GridData data = new GridData(768);
        data.widthHint = 305;
        this.componentCombo.setLayoutData((Object)data);
        this.synchHelper.synchCombo(this.componentCombo, "IJ2EEComponentImportDataModelProperties.PROJECT_NAME", new Control[]{componentLabel});
        new Label(parent, 0);
        this.createServerTargetComposite(parent);
    }

    protected void createServerTargetComposite(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(J2EEUIMessages.getResourceString("2"));
        Combo serverTargetCombo = new Combo(parent, 2056);
        serverTargetCombo.setLayoutData((Object)new GridData(768));
        Button newServerTargetButton = new Button(parent, 0);
        newServerTargetButton.setText(J2EEUIMessages.getResourceString("14"));
        newServerTargetButton.setLayoutData((Object)new GridData(768));
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2EEImportPage.this.launchNewRuntimeWizard(J2EEImportPage.this.getShell(), J2EEImportPage.this.model);
            }
        });
        Control[] deps = new Control[]{label, newServerTargetButton};
        this.synchHelper.synchCombo(serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
    }

    protected IDialogSettings getDialogSettings() {
        return J2EEUIPlugin.getDefault().getDialogSettings();
    }

    protected String getProjectImportLabel() {
        return null;
    }

    protected void createFileNameComposite(Composite parent) {
        Label fileLabel = new Label(parent, 0);
        fileLabel.setText(this.getFileImportLabel());
        this.fileNameCombo = new Combo(parent, 2052);
        this.fileNameCombo.setLayoutData((Object)new GridData(768));
        Button browseButton = new Button(parent, 8);
        browseButton.setText(defBrowseButtonLabel);
        browseButton.setLayoutData((Object)new GridData(768));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2EEImportPage.this.handleFileBrowseButtonPressed();
            }
        });
        browseButton.setEnabled(true);
        this.synchHelper.synchCombo(this.fileNameCombo, "IJ2EEArtifactImportDataModelProperties.FILE_NAME", new Control[]{fileLabel, browseButton});
    }

    protected void handleFileBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.fileNameCombo.getShell());
        dialog.setFilterExtensions(this.getFilterExpression());
        String filename = dialog.open();
        if (filename != null) {
            this.model.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)filename);
        }
    }

    protected String[] getFilterExpression() {
        return new String[0];
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LABEL + this.getFileNamesStoreID());
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                if (sourceNames[i] == null) {
                    sourceNames[i] = "";
                }
                ++i;
            }
            this.fileNameCombo.setItems(sourceNames);
        }
    }

    public void storeDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LABEL + this.getFileNamesStoreID());
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            ArrayList<String> newNames = new ArrayList<String>();
            int i = 0;
            while (i < sourceNames.length && i < 5) {
                if (sourceNames[i].trim().length() > 0) {
                    newNames.add(sourceNames[i]);
                }
                ++i;
            }
            String text = this.fileNameCombo.getText();
            newNames.remove(text);
            newNames.add(0, text);
            sourceNames = new String[newNames.size()];
            newNames.toArray(sourceNames);
            settings.put(STORE_LABEL + this.getFileNamesStoreID(), sourceNames);
            DataModelFacetCreationWizardPage.saveRuntimeSettings((IDialogSettings)settings, (IDataModel)this.model);
        }
    }

    public void restoreDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        DataModelFacetCreationWizardPage.restoreRuntimeSettings((IDialogSettings)settings, (IDataModel)this.model);
    }

    protected String getFileNamesStoreID() {
        return null;
    }

    protected String getFileImportLabel() {
        return null;
    }

    protected void enter() {
        super.enter();
    }

    private boolean launchNewRuntimeWizard(Shell shell, IDataModel model) {
        DataModelPropertyDescriptor[] preAdditionDescriptors = model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        boolean isOK = ServerUIUtil.showNewRuntimeWizard((Shell)shell, (String)"", (String)"");
        if (isOK) {
            DataModelPropertyDescriptor[] postAdditionDescriptors = model.getValidPropertyDescriptors("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            Object[] preAddition = new Object[preAdditionDescriptors.length];
            int i = 0;
            while (i < preAddition.length) {
                preAddition[i] = preAdditionDescriptors[i].getPropertyValue();
                ++i;
            }
            Object[] postAddition = new Object[postAdditionDescriptors.length];
            int i2 = 0;
            while (i2 < postAddition.length) {
                postAddition[i2] = postAdditionDescriptors[i2].getPropertyValue();
                ++i2;
            }
            Object newAddition = ProjectUtilities.getNewObject((Object[])preAddition, (Object[])postAddition);
            model.notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 4);
            if (newAddition != null) {
                model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", newAddition);
            }
        }
        return isOK;
    }
}

