/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.refactoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.core.internal.java.search.JavaSearchDocumentDelegate;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.java.refactoring.JSPRenameChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class BasicRefactorSearchRequestor
extends SearchRequestor {
    IJavaElement fElement = null;
    private String fNewName = "";
    private HashMap fSearchDocPath2JavaEditMap = null;

    public BasicRefactorSearchRequestor(IJavaElement element, String newName) {
        this.fNewName = newName;
        this.fElement = element;
        this.fSearchDocPath2JavaEditMap = new HashMap();
    }

    public IJavaElement getElement() {
        return this.fElement;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public void acceptSearchMatch(SearchMatch javaMatch) throws CoreException {
        String renameText;
        String matchDocumentPath = javaMatch.getResource().getFullPath().toString();
        SearchDocument searchDoc = JSPSearchSupport.getInstance().getSearchDocument(matchDocumentPath);
        if (searchDoc != null && searchDoc instanceof JavaSearchDocumentDelegate && (renameText = this.getRenameText((JavaSearchDocumentDelegate)searchDoc, javaMatch)) != null) {
            this.addJavaEdit(searchDoc.getPath(), new ReplaceEdit(javaMatch.getOffset(), javaMatch.getLength(), renameText));
        }
    }

    protected String getRenameText(JavaSearchDocumentDelegate searchDoc, SearchMatch javaMatch) {
        return this.getNewName();
    }

    private void addJavaEdit(String searchDocPath, ReplaceEdit javaEdit) {
        Object o = this.fSearchDocPath2JavaEditMap.get(searchDocPath);
        if (o != null) {
            MultiTextEdit multi = (MultiTextEdit)o;
            multi.addChild((TextEdit)javaEdit);
        } else {
            MultiTextEdit multi = new MultiTextEdit();
            multi.addChild((TextEdit)javaEdit);
            this.fSearchDocPath2JavaEditMap.put(searchDocPath, multi);
        }
    }

    public Change[] getChanges() {
        JSPSearchSupport support = JSPSearchSupport.getInstance();
        ArrayList<Change> changes = new ArrayList<Change>();
        Iterator keys = this.fSearchDocPath2JavaEditMap.keySet().iterator();
        String searchDocPath = null;
        SearchDocument delegate = null;
        while (keys.hasNext()) {
            searchDocPath = (String)keys.next();
            MultiTextEdit javaEdit = (MultiTextEdit)this.fSearchDocPath2JavaEditMap.get(searchDocPath);
            delegate = support.getSearchDocument(searchDocPath);
            if (delegate == null || !(delegate instanceof JavaSearchDocumentDelegate)) continue;
            JavaSearchDocumentDelegate javaDelegate = (JavaSearchDocumentDelegate)delegate;
            changes.add(this.createChange(javaDelegate, javaDelegate.getJspTranslation().getJspEdit((TextEdit)javaEdit)));
        }
        return changes.toArray(new Change[changes.size()]);
    }

    public Change[] getChanges(RefactoringParticipant participant) {
        JSPSearchSupport support = JSPSearchSupport.getInstance();
        ArrayList<Change> changes = new ArrayList<Change>();
        Iterator keys = this.fSearchDocPath2JavaEditMap.keySet().iterator();
        String searchDocPath = null;
        SearchDocument delegate = null;
        while (keys.hasNext()) {
            searchDocPath = (String)keys.next();
            MultiTextEdit javaEdit = (MultiTextEdit)this.fSearchDocPath2JavaEditMap.get(searchDocPath);
            delegate = support.getSearchDocument(searchDocPath);
            if (delegate == null || !(delegate instanceof JavaSearchDocumentDelegate)) continue;
            JavaSearchDocumentDelegate javaDelegate = (JavaSearchDocumentDelegate)delegate;
            Change change = this.createChange(javaDelegate, javaDelegate.getJspTranslation().getJspEdit((TextEdit)javaEdit), participant);
            changes.add(change);
        }
        return changes.toArray(new Change[changes.size()]);
    }

    private Change createChange(JavaSearchDocumentDelegate searchDoc, TextEdit edit) {
        IDocument doc = searchDoc.getJspTranslation().getJspDocument();
        String file = searchDoc.getFile().getName();
        String description = this.getDescription();
        try {
            String lineNumber = Integer.toString(doc.getLineOfOffset(edit.getOffset()) + 1);
            description = String.valueOf(description) + " " + NLS.bind((String)JSPUIMessages.BasicRefactorSearchRequestor_1, (Object[])new String[]{file, lineNumber});
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return new JSPRenameChange(searchDoc.getFile(), doc, edit, description);
    }

    private Change createChange(JavaSearchDocumentDelegate searchDoc, TextEdit edit, RefactoringParticipant participant) {
        IDocument doc = searchDoc.getJspTranslation().getJspDocument();
        String description = this.getDescription();
        TextChange existingChange = participant.getTextChange((Object)searchDoc.getFile());
        JSPRenameChange change = null;
        if (existingChange != null) {
            try {
                existingChange.addEdit(edit);
            }
            catch (MalformedTreeException e) {
                Logger.logException("MalformedTreeException while adding edit " + edit + " to existing change " + (Object)((Object)change), e);
            }
            TextEditGroup group = new TextEditGroup(description, edit);
            existingChange.addTextEditGroup(group);
        } else {
            change = new JSPRenameChange(searchDoc.getFile(), doc, edit, searchDoc.getFile().getName());
            TextEditGroup group = new TextEditGroup(description, edit);
            change.addTextEditGroup(group);
        }
        return change;
    }

    protected boolean isFullyQualified(String matchText) {
        if (this.getElement() instanceof IType) {
            String pkg = ((IType)this.getElement()).getPackageFragment().getElementName();
            return matchText.startsWith(pkg);
        }
        return false;
    }

    protected String getDescription() {
        return "";
    }
}

