/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.common.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTBeanPropertyWorkingCopy
extends JDTBeanProperty {
    private final List _setters = new ArrayList();
    private IMethod _isGetter;
    private final Map<String, String> _resolvedSignatureMap;

    public JDTBeanPropertyWorkingCopy(IType type, Map<String, String> resolvedSignatureMap) {
        super(type);
        this._resolvedSignatureMap = resolvedSignatureMap;
    }

    public JDTBeanPropertyWorkingCopy(IType type) {
        super(type);
        this._resolvedSignatureMap = new HashMap<String, String>();
    }

    public JDTBeanProperty toValueObject() {
        IMethod getter = this.getIsGetter() != null ? this.getIsGetter() : this.getGetter();
        IMethod matchedSetter = null;
        if (getter != null) {
            matchedSetter = this.determineMatchedSetter(getter);
        } else if (this._setters.size() > 0) {
            matchedSetter = (IMethod)this._setters.get(0);
        }
        JDTBeanProperty beanProp = new JDTBeanProperty(this._type);
        beanProp.setGetter(getter);
        beanProp.setSetter(matchedSetter);
        return beanProp;
    }

    private IMethod determineMatchedSetter(IMethod getter) {
        IMethod matchedSetter = null;
        if (this._setters.size() < 1) {
            return null;
        }
        try {
            String getterSig = this.getResolvedSignature(this._type, getter.getReturnType());
            for (IMethod setter : this._setters) {
                assert (setter.getNumberOfParameters() == 1);
                String paramSig = this.getResolvedSignature(this._type, setter.getParameterTypes()[0]);
                if (!paramSig.equals(getterSig)) continue;
                matchedSetter = setter;
                break;
            }
        }
        catch (JavaModelException jme) {
            JSFCommonPlugin.log((Exception)((Object)jme), "Error determining getter return type, bean properties analysis may be inaccurate");
        }
        return matchedSetter;
    }

    @Override
    public void setGetter(IMethod getter) {
        super.setGetter(getter);
    }

    public void setIsGetter(IMethod isGetter) {
        this._isGetter = isGetter;
    }

    public void addSetter(IMethod setter) {
        if (setter != null && setter.getNumberOfParameters() == 1) {
            this._setters.add(setter);
        }
    }

    @Override
    public final IMethod getSetter() {
        throw new UnsupportedOperationException("Setter not calculated in working copy.  Call toValueObject().getSetter()");
    }

    public IMethod getIsGetter() {
        return this._isGetter;
    }

    private String getResolvedSignature(IType type, String unresolved) {
        String resolved = this._resolvedSignatureMap.get(unresolved);
        if (resolved == null) {
            resolved = TypeUtil.resolveTypeSignature(this._type, unresolved);
            this._resolvedSignatureMap.put(unresolved, resolved);
        }
        return resolved;
    }
}

