/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ejb.operations;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.ejb.internal.operations.NewMessageDrivenBeanClassDataModelProvider;
import org.eclipse.jst.j2ee.ejb.internal.operations.NewSessionBeanClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.operations.INewJavaClassDataModelProperties;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.ejb.operations.EJBProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;

public class AddEJBeanOperationTest
extends OperationTestCase
implements INewJavaClassDataModelProperties {
    public static final String EJB_PROJECT_NAME = "EjbProject";
    public static final String PACKAGE = "test";
    public static final String SESSION_BEAN_NAME = "TestSessionBean";
    public static final String SESSION_BEAN_CLASS_NAME = "test.TestSessionBean";
    public static final String SESSION_BEAN_LOCAL_NAME = "TestSessionBeanLocal";
    public static final String SESSION_BEAN_LOCAL_CLASS_NAME = "test.TestSessionBeanLocal";
    public static final String MESSAGE_DRIVEN_BEAN_NAME = "TestMDBean";
    public static final String MESSAGE_DRIVEN_BEAN_CLASS_NAME = "test.TestMDBean";

    public AddEJBeanOperationTest() {
    }

    public AddEJBeanOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(AddEJBeanOperationTest.class);
    }

    public void testAddSessionBean_EJB30_Defaults_NoJETEmitter() throws Exception {
        this.disableJETEmitter();
        this.testAddSessionBean_EJB30_Defaults();
        this.enableJETEmitter();
    }

    public void testAddSessionBean_EJB30_Defaults() throws Exception {
        this.createEJBProject(EJB_PROJECT_NAME, JavaEEFacetConstants.EJB_3);
        ProjectUtilities.getProject((String)EJB_PROJECT_NAME);
        this.addSessionBean_Defaults();
        this.assertJavaFileExists(SESSION_BEAN_CLASS_NAME);
        this.assertJavaFileExists(SESSION_BEAN_LOCAL_CLASS_NAME);
    }

    public void testAddMessageDrivenBean_EJB30_Defaults_NoJETEmitter() throws Exception {
        this.disableJETEmitter();
        this.testAddMessageDrivenBean_EJB30_Defaults();
        this.enableJETEmitter();
    }

    public void testAddMessageDrivenBean_EJB30_Defaults() throws Exception {
        this.createEJBProject(EJB_PROJECT_NAME, JavaEEFacetConstants.EJB_3);
        ProjectUtilities.getProject((String)EJB_PROJECT_NAME);
        this.addMessageDrivenBean_Defaults();
        this.assertJavaFileExists(MESSAGE_DRIVEN_BEAN_CLASS_NAME);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void enableJETEmitter() {
        Preferences preferences = J2EEPlugin.getDefault().getPluginPreferences();
        preferences.setValue("dynamicTranslationOfJetTemplates", true);
    }

    private void disableJETEmitter() {
        Preferences preferences = J2EEPlugin.getDefault().getPluginPreferences();
        preferences.setValue("dynamicTranslationOfJetTemplates", false);
    }

    private void createEJBProject(String projectName, IProjectFacetVersion version) throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel(projectName, null, null, null, version, false);
        AddEJBeanOperationTest.runAndVerify((IDataModel)dm);
    }

    private void addSessionBean_Defaults() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel(NewSessionBeanClassDataModelProvider.class);
        dm.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)EJB_PROJECT_NAME);
        dm.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)PACKAGE);
        dm.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)SESSION_BEAN_NAME);
        AddEJBeanOperationTest.runAndVerify((IDataModel)dm);
    }

    private void addMessageDrivenBean_Defaults() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel(NewMessageDrivenBeanClassDataModelProvider.class);
        dm.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)EJB_PROJECT_NAME);
        dm.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)PACKAGE);
        dm.setProperty("NewJavaClassDataModel.CLASS_NAME", (Object)MESSAGE_DRIVEN_BEAN_NAME);
        AddEJBeanOperationTest.runAndVerify((IDataModel)dm);
    }

    private void assertJavaFileExists(String fullyQualifiedName) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaModel().getJavaProject(EJB_PROJECT_NAME);
        AddEJBeanOperationTest.assertNotNull((String)"Java project EjbProject not found", (Object)javaProject);
        IType type = javaProject.findType(fullyQualifiedName);
        AddEJBeanOperationTest.assertNotNull((String)("Java type " + fullyQualifiedName + " not found"), (Object)type);
        IFile file = (IFile)type.getResource();
        AddEJBeanOperationTest.assertNotNull((String)("Source file for Java type " + fullyQualifiedName + " not found"), (Object)file);
        AddEJBeanOperationTest.assertTrue((boolean)file.exists());
    }
}

