/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindDeclarationsAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class FindDeclarationsInWorkingSetAction
extends FindDeclarationsAction {
    private IWorkingSet[] fWorkingSet;

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site) {
        this(site, null);
    }

    public FindDeclarationsInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        super(site);
        this.fWorkingSet = workingSets;
    }

    public FindDeclarationsInWorkingSetAction(JavaEditor editor) {
        this(editor, null);
    }

    public FindDeclarationsInWorkingSetAction(JavaEditor editor, IWorkingSet[] workingSets) {
        super(editor);
        this.fWorkingSet = workingSets;
    }

    void init() {
        this.setText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindDeclarationsInWorkingSetAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_DECL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_declarations_in_working_set_action");
    }

    QuerySpecification createQuery(IJavaScriptElement element) throws JavaScriptModelException, InterruptedException {
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        IWorkingSet[] workingSets = this.fWorkingSet;
        if (this.fWorkingSet == null && (workingSets = factory.queryWorkingSets()) == null) {
            return null;
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        IJavaScriptSearchScope scope = factory.createJavaSearchScope(workingSets, true);
        String description = factory.getWorkingSetScopeDescription(workingSets, true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

