/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriStateCheckBoxModelAdapter {
    protected final WritablePropertyValueModel<Boolean> booleanHolder;
    protected final PropertyChangeListener booleanChangeListener;
    protected final TriStateCheckBox button;
    protected final SelectionListener buttonSelectionListener;
    protected final DisposeListener buttonDisposeListener;

    public static TriStateCheckBoxModelAdapter adapt(WritablePropertyValueModel<Boolean> booleanHolder, TriStateCheckBox button) {
        return new TriStateCheckBoxModelAdapter(booleanHolder, button);
    }

    protected TriStateCheckBoxModelAdapter(WritablePropertyValueModel<Boolean> booleanHolder, TriStateCheckBox button) {
        Assert.isNotNull(booleanHolder, (String)"The boolean holder cannot be null");
        Assert.isNotNull((Object)button, (String)"The check box cannot be null");
        this.booleanHolder = booleanHolder;
        this.button = button;
        this.booleanChangeListener = this.buildBooleanChangeListener();
        this.booleanHolder.addPropertyChangeListener("value", this.booleanChangeListener);
        this.buttonDisposeListener = this.buildButtonDisposeListener();
        this.button.addDisposeListener(this.buttonDisposeListener);
        this.buttonSelectionListener = this.buildButtonSelectionListener();
        this.button.addSelectionListener(this.buttonSelectionListener);
        this.setButtonSelection((Boolean)this.booleanHolder.getValue());
    }

    protected PropertyChangeListener buildBooleanChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildBooleanChangeListener_());
    }

    protected PropertyChangeListener buildBooleanChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                TriStateCheckBoxModelAdapter.this.booleanChanged(event);
            }

            public String toString() {
                return "tri-state boolean listener";
            }
        };
    }

    protected SelectionListener buildButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TriStateCheckBoxModelAdapter.this.buttonSelected(event);
            }

            public String toString() {
                return "tri-state button selection listener";
            }
        };
    }

    protected DisposeListener buildButtonDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TriStateCheckBoxModelAdapter.this.buttonDisposed(event);
            }

            public String toString() {
                return "tri-state button dispose listener";
            }
        };
    }

    protected void booleanChanged(PropertyChangeEvent event) {
        this.setButtonSelection((Boolean)event.getNewValue());
    }

    protected void setButtonSelection(Boolean selection) {
        if (this.button.isDisposed()) {
            return;
        }
        this.button.setSelection(selection);
    }

    protected void buttonSelected(SelectionEvent event) {
        if (this.button.isDisposed()) {
            return;
        }
        this.booleanHolder.setValue((Object)this.button.getSelection());
    }

    protected void buttonDisposed(DisposeEvent event) {
        this.button.removeSelectionListener(this.buttonSelectionListener);
        this.button.removeDisposeListener(this.buttonDisposeListener);
        this.booleanHolder.removePropertyChangeListener("value", this.booleanChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.booleanHolder);
    }
}

