/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.jface;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.ui.internal.listeners.SWTListChangeListenerWrapper;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

public class StructuredContentProviderAdapter
implements IStructuredContentProvider {
    protected ListValueModel listHolder;
    protected final AbstractListViewer listViewer;
    protected final ListChangeListener listChangeListener = this.buildListChangeListener();

    public static StructuredContentProviderAdapter adapt(AbstractListViewer listViewer, ListValueModel listHolder) {
        return new StructuredContentProviderAdapter(listViewer, listHolder);
    }

    public static StructuredContentProviderAdapter adapt(AbstractListViewer listViewer, CollectionValueModel collectionHolder) {
        return new StructuredContentProviderAdapter(listViewer, collectionHolder);
    }

    protected StructuredContentProviderAdapter(AbstractListViewer listViewer, ListValueModel listHolder) {
        this.listViewer = listViewer;
        this.listViewer.setContentProvider((IContentProvider)this);
        this.listViewer.setInput((Object)listHolder);
    }

    protected StructuredContentProviderAdapter(AbstractListViewer listViewer, CollectionValueModel collectionHolder) {
        this(listViewer, (ListValueModel)new CollectionListValueModelAdapter(collectionHolder));
    }

    protected ListChangeListener buildListChangeListener() {
        return new SWTListChangeListenerWrapper(this.buildListChangeListener_());
    }

    protected ListChangeListener buildListChangeListener_() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                StructuredContentProviderAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                StructuredContentProviderAdapter.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                StructuredContentProviderAdapter.this.itemsReplaced(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                StructuredContentProviderAdapter.this.itemsMoved(e);
            }

            public void listCleared(ListChangeEvent e) {
                StructuredContentProviderAdapter.this.listCleared();
            }

            public void listChanged(ListChangeEvent e) {
                StructuredContentProviderAdapter.this.listChanged();
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != this.listHolder) {
            throw new IllegalArgumentException("invalid input element: " + inputElement);
        }
        return this.listHolder.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer != this.listViewer) {
            throw new IllegalArgumentException("invalid viewer: " + viewer);
        }
        if (oldInput != this.listHolder) {
            throw new IllegalArgumentException("invalid old input: " + oldInput);
        }
        this.modelChanged((ListValueModel)oldInput, (ListValueModel)newInput);
    }

    public void dispose() {
    }

    protected void modelChanged(ListValueModel oldModel, ListValueModel newModel) {
        if (oldModel != null) {
            this.listHolder.removeListChangeListener("list values", this.listChangeListener);
        }
        this.listHolder = newModel;
        if (newModel != null) {
            this.listHolder.addListChangeListener("list values", this.listChangeListener);
        }
    }

    public ListValueModel model() {
        return this.listHolder;
    }

    public void setModel(ListValueModel listHolder) {
        this.listViewer.setInput((Object)listHolder);
    }

    public void setModel(CollectionValueModel collectionHolder) {
        this.setModel((ListValueModel)new CollectionListValueModelAdapter(collectionHolder));
    }

    protected void itemsAdded(ListChangeEvent e) {
        int i = e.getIndex();
        ListIterator stream = e.items();
        while (stream.hasNext()) {
            this.listViewer.insert(stream.next(), i);
            ++i;
        }
    }

    protected void itemsRemoved(ListChangeEvent e) {
        this.listViewer.remove(CollectionTools.array((Iterator)e.items(), (int)e.itemsSize()));
    }

    protected void itemsReplaced(ListChangeEvent e) {
        this.listViewer.remove(CollectionTools.array((Iterator)e.replacedItems(), (int)e.itemsSize()));
        int i = e.getIndex();
        ListIterator stream = e.items();
        while (stream.hasNext()) {
            this.listViewer.insert(stream.next(), i);
            ++i;
        }
    }

    protected void itemsMoved(ListChangeEvent e) {
        int len = e.getMoveLength();
        Object[] items = new Object[len];
        int offset = e.getSourceIndex();
        int i = 0;
        while (i < len) {
            items[i] = this.listHolder.get(offset + i);
            ++i;
        }
        this.listViewer.remove(items);
        offset = e.getTargetIndex();
        i = 0;
        while (i < len) {
            this.listViewer.insert(items[i], offset + i);
            ++i;
        }
    }

    protected void listCleared() {
        this.listViewer.refresh();
    }

    protected void listChanged() {
        this.listViewer.refresh();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.listHolder);
    }
}

