/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.AttrChangeContext;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DefaultCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICounter;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class CounterFormatter
extends DefaultCSSSourceFormatter {
    private static CounterFormatter instance;

    CounterFormatter() {
    }

    public StringBuffer formatAttrChanged(ICSSNode node, ICSSAttr attr, boolean insert, AttrChangeContext context) {
        String func;
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        StringBuffer source = new StringBuffer();
        if (node == null || attr == null) {
            return source;
        }
        if (!("identifier".equalsIgnoreCase(attr.getName()) || "liststyle".equalsIgnoreCase(attr.getName()) || "separator".equalsIgnoreCase(attr.getName()))) {
            return source;
        }
        IndexedRegion iNode = (IndexedRegion)node;
        context.start = iNode.getStartOffset();
        context.end = iNode.getEndOffset();
        ICounter counter = (ICounter)node;
        String quote = preferences.getString("quote");
        String sep = counter.getSeparator();
        String ident = counter.getIdentifier();
        String style = counter.getListStyle();
        if ("identifier".equalsIgnoreCase(attr.getName())) {
            ident = insert ? attr.getValue() : "";
        } else if ("liststyle".equalsIgnoreCase(attr.getName())) {
            style = insert ? attr.getValue() : null;
        } else if ("separator".equalsIgnoreCase(attr.getName())) {
            sep = insert ? attr.getValue() : null;
        }
        quote = CSSUtil.detectQuote(sep, quote);
        sep = sep == null || sep.length() == 0 ? null : String.valueOf(quote) + sep + quote;
        String string = func = sep == null || sep.length() == 0 ? "counter(" : "counters(";
        if (preferences.getInt("propValueCase") == 2) {
            ident = ident.toUpperCase();
            style = style.toUpperCase();
            func = func.toUpperCase();
        } else {
            ident = ident.toLowerCase();
            style = style.toLowerCase();
        }
        if (sep == null || sep.length() == 0) {
            source.append(func);
            this.appendSpaceBefore(node, ident, source);
            source.append(ident);
        } else {
            source.append(func);
            this.appendSpaceBefore(node, ident, source);
            source.append(ident);
            source.append(",");
            this.appendSpaceBefore(node, sep, source);
            source.append(sep);
        }
        if (style != null && style.length() != 0) {
            source.append(",");
            this.appendSpaceBefore(node, style, source);
        }
        source.append(")");
        return source;
    }

    protected void formatPre(ICSSNode node, StringBuffer source) {
        int start = ((IndexedRegion)node).getStartOffset();
        int end = ((IndexedRegion)node).getEndOffset();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        if (end > 0) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            boolean skipSpace = false;
            int i = 0;
            while (i < regions.length) {
                if (i != 0 && !skipSpace) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                skipSpace = false;
                source.append(this.decoratedPropValueRegion(regions[i], stgy));
                if (regions[i].getType() == "DECLARATION_VALUE_FUNCTION") {
                    skipSpace = true;
                }
                ++i;
            }
        } else {
            String func;
            ICounter counter = (ICounter)node;
            String quote = preferences.getString("quote");
            String separator = counter.getSeparator();
            quote = CSSUtil.detectQuote(separator, quote);
            String sep = separator == null || separator.length() == 0 ? null : String.valueOf(quote) + separator + quote;
            String ident = counter.getIdentifier();
            String style = counter.getListStyle();
            String string = func = sep == null || sep.length() == 0 ? "counter(" : "counters(";
            if (ident == null) {
                ident = "";
            }
            if (style == null) {
                style = "";
            }
            if (preferences.getInt("propValueCase") == 2) {
                ident = ident.toUpperCase();
                style = style.toUpperCase();
                func = func.toUpperCase();
            } else {
                ident = ident.toLowerCase();
                style = style.toLowerCase();
            }
            if (sep == null || sep.length() == 0) {
                source.append(func);
                this.appendSpaceBefore(node, ident, source);
                source.append(ident);
            } else {
                source.append(func);
                this.appendSpaceBefore(node, ident, source);
                source.append(ident);
                source.append(",");
                this.appendSpaceBefore(node, sep, source);
                source.append(sep);
            }
            if (style != null && style.length() != 0) {
                source.append(",");
                this.appendSpaceBefore(node, style, source);
            }
            source.append(")");
        }
    }

    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || CounterFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedPropValueRegion(regions[i], stgy));
            ++i;
        }
        if (CounterFormatter.needS(outside[1]) && !this.isIncludesPreEnd(node, region)) {
            this.appendSpaceBefore(node, outside[1], source);
        }
    }

    public int getAttrInsertPos(ICSSNode node, String attrName) {
        if (node == null || attrName == null || attrName.length() == 0) {
            return -1;
        }
        IndexedRegion iNode = (IndexedRegion)node;
        if ("identifier".equalsIgnoreCase(attrName)) {
            ICSSAttr attr = (ICSSAttr)node.getAttributes().getNamedItem("identifier");
            if (attr != null && ((IndexedRegion)attr).getEndOffset() > 0) {
                return ((IndexedRegion)attr).getStartOffset();
            }
            if (iNode.getEndOffset() <= 0) {
                return -1;
            }
            IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(iNode.getEndOffset() - 1);
            RegionIterator it = new RegionIterator(flatNode, flatNode.getRegionAtCharacterOffset(iNode.getEndOffset() - 1));
            while (it.hasPrev()) {
                ITextRegion region = it.prev();
                if (region.getType() != "DECLARATION_VALUE_FUNCTION") continue;
                return it.getStructuredDocumentRegion().getEndOffset(region);
            }
            return ((IndexedRegion)node).getEndOffset();
        }
        if ("liststyle".equalsIgnoreCase(attrName)) {
            ICSSAttr attr = (ICSSAttr)node.getAttributes().getNamedItem("liststyle");
            if (attr != null && ((IndexedRegion)attr).getEndOffset() > 0) {
                return ((IndexedRegion)attr).getStartOffset();
            }
            IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(iNode.getEndOffset() - 1);
            RegionIterator it = new RegionIterator(flatNode, flatNode.getRegionAtCharacterOffset(iNode.getEndOffset() - 1));
            while (it.hasPrev()) {
                ITextRegion region = it.prev();
                if (region.getType() == "DECLARATION_VALUE_OPERATOR") {
                    return it.getStructuredDocumentRegion().getEndOffset(region);
                }
                if (region.getType() != "DECLARATION_VALUE_FUNCTION") continue;
                return it.getStructuredDocumentRegion().getEndOffset(region);
            }
            return ((IndexedRegion)node).getEndOffset();
        }
        if ("separator".equalsIgnoreCase(attrName)) {
            ICSSAttr attr = (ICSSAttr)node.getAttributes().getNamedItem("separator");
            if (attr != null && ((IndexedRegion)attr).getEndOffset() > 0) {
                return ((IndexedRegion)attr).getStartOffset();
            }
            IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(iNode.getEndOffset() - 1);
            RegionIterator it = new RegionIterator(flatNode, flatNode.getRegionAtCharacterOffset(iNode.getEndOffset() - 1));
            boolean hasComma = false;
            while (it.hasPrev()) {
                ITextRegion region = it.prev();
                if (region.getType() == "DECLARATION_VALUE_OPERATOR") {
                    if (!hasComma) {
                        hasComma = true;
                        continue;
                    }
                    return it.getStructuredDocumentRegion().getEndOffset(region);
                }
                if (region.getType() != "DECLARATION_VALUE_FUNCTION") continue;
                return it.getStructuredDocumentRegion().getEndOffset(region);
            }
            return ((IndexedRegion)node).getEndOffset();
        }
        return -1;
    }

    public static synchronized CounterFormatter getInstance() {
        if (instance == null) {
            instance = new CounterFormatter();
        }
        return instance;
    }
}

