/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.analyzer;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.proxy.core.ConfigurationContributorAdapter;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.osgi.framework.Bundle;

class ServletBeanProxyContributor
extends ConfigurationContributorAdapter {
    private final IProject _project;
    private final JSFVersion _jsfVersion;

    public ServletBeanProxyContributor(IProject project) {
        this._project = project;
        this._jsfVersion = ServletBeanProxyContributor.getProjectVersion(project);
        if (this._jsfVersion == null) {
            throw new IllegalArgumentException("jsfVersion must not be null");
        }
    }

    public void contributeClasspaths(IConfigurationContributionController controller) throws CoreException {
        if (this._jsfVersion != JSFVersion.V1_2) {
            Bundle servletBundle = Platform.getBundle((String)"javax.servlet");
            controller.contributeClasspath(servletBundle, null, 0, true);
            Bundle jspBundle = Platform.getBundle((String)"javax.servlet.jsp");
            controller.contributeClasspath(jspBundle, null, 0, true);
        } else {
            Bundle coreBundle = JSFCorePlugin.getDefault().getBundle();
            IJavaProject javaProject = JavaCore.create((IProject)this._project);
            this.maybeAddJar(controller, "javax.servlet.jsp.tagext.JspIdConsumer", javaProject, coreBundle, "/jars/fake_jsp_21.jar");
            this.maybeAddJar(controller, "javax.el.ELException", javaProject, coreBundle, "/jars/fake_el.jar");
        }
    }

    private void maybeAddJar(IConfigurationContributionController controller, String addIfTypeNameNotFound, IJavaProject javaProject, Bundle bundle, String path) {
        try {
            IType type = javaProject.findType(addIfTypeNameNotFound);
            if (type == null) {
                controller.contributeClasspath(bundle, path, 0, false);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    static JSFVersion getProjectVersion(IProject project) {
        try {
            if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.jsf", (String)"1.0")) {
                return JSFVersion.V1_0;
            }
            if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.jsf", (String)"1.1")) {
                return JSFVersion.V1_1;
            }
            if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.jsf", (String)"1.2")) {
                return JSFVersion.V1_2;
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.log("checking project version", e);
        }
        return null;
    }
}

