/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.adapters.jdom.JavaJDOMAdapterFactory;
import org.eclipse.jem.internal.plugin.JavaPlugin;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JavaModelListener;

public class JavaReflectionSynchronizer
extends JavaModelListener {
    protected JavaJDOMAdapterFactory fAdapterFactory;
    protected boolean flushedAll = false;
    protected List flushTypes = new ArrayList();
    protected List flushTypePlusInner = new ArrayList();
    protected List notifications = new ArrayList();

    public JavaReflectionSynchronizer(JavaJDOMAdapterFactory synchronizee) {
        this.fAdapterFactory = synchronizee;
    }

    protected IJavaProject getJavaProject() {
        return this.getAdapterFactory().getJavaProject();
    }

    protected Notification doFlush(IType element) {
        return this.getAdapterFactory().flushReflectionNoNotification(element.getFullyQualifiedName());
    }

    protected Notification doFlush(ICompilationUnit element) {
        return this.getAdapterFactory().flushReflectionPlusInnerNoNotification(this.getFullNameFromElement(element));
    }

    protected void flush(IType element) {
        if (!this.flushTypes.contains(element)) {
            this.flushTypes.add(element);
        }
    }

    protected void flush(ICompilationUnit element) {
        if (!this.flushTypePlusInner.contains(element)) {
            this.flushTypePlusInner.add(element);
        }
    }

    protected void flushPackage(String packageName, boolean noFlushIfSourceFound) {
        this.notifications.addAll(this.getAdapterFactory().flushPackageNoNotification(packageName, noFlushIfSourceFound));
    }

    protected JavaJDOMAdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                if ((delta.getFlags() & 0x40000) != 0) {
                    this.flush(element);
                    break;
                }
                if ((delta.getFlags() & 1) != 0 || (delta.getFlags() & 8) == 0) break;
                this.processChildren((IJavaElement)element, delta);
                break;
            }
            case 1: 
            case 2: {
                if (element.isWorkingCopy()) break;
                this.disAssociateSourcePlusInner(this.getFullNameFromElement(element));
            }
        }
    }

    protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
        if (this.isInClasspath(element)) {
            if (delta.getKind() == 2 || delta.getKind() == 4 && (delta.getFlags() & 0x400) != 0) {
                if (element.equals(this.getAdapterFactory().getJavaProject())) {
                    this.stopSynchronizer();
                } else {
                    this.flushAll();
                }
                return;
            }
            if (delta.getKind() == 1 || this.isClasspathResourceChange(delta)) {
                this.flushAll();
                return;
            }
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void processJavaElementChanged(IClassFile element, IJavaElementDelta delta) {
        int kind = delta.getKind();
        if (kind == 2 || kind == 1) {
            this.disAssociateSourcePlusInner(this.getFullNameFromElement(element));
            return;
        }
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int ii = 0;
        while (ii < children.length) {
            this.processDelta(children[ii]);
            ++ii;
        }
    }

    protected void processJavaElementChanged(IPackageFragmentRoot element, IJavaElementDelta delta) {
        if (this.flushedAll) {
            return;
        }
        if (this.isClassPathChange(delta)) {
            this.flushAll();
        } else {
            super.processJavaElementChanged(element, delta);
        }
    }

    protected void processJavaElementChanged(IPackageFragment element, IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                this.flushPackage(delta.getElement().getElementName(), false);
                break;
            }
            case 2: {
                this.getAdapterFactory().flushPackage(delta.getElement().getElementName(), false);
                break;
            }
            default: {
                super.processJavaElementChanged(element, delta);
            }
        }
    }

    protected void processJavaElementChanged(IType element, IJavaElementDelta delta) {
        int kind = delta.getKind();
        if (kind == 2 || kind == 1) {
            this.disAssociateSourcePlusInner(element.getFullyQualifiedName());
        } else {
            this.flush(element);
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void processRemoveOrAdd(ICompilationUnit element) {
        this.disAssociateSource(this.getFullNameFromElement(element));
    }

    protected String getFullNameFromElement(ICompilationUnit cu) {
        IType primary = cu.findPrimaryType();
        if (primary != null) {
            return primary.getFullyQualifiedName();
        }
        String filename = cu.getElementName();
        int idx = filename.lastIndexOf(46);
        if (idx != -1) {
            filename = filename.substring(0, idx);
        }
        return String.valueOf(((IPackageFragment)cu.getParent()).getElementName()) + '.' + filename;
    }

    protected String getFullNameFromElement(IClassFile cf) {
        return cf.getType().getFullyQualifiedName();
    }

    protected String getFullNameFromElement(IJavaElement element) {
        String name = element.getElementName();
        if (element == null || name.length() <= 5 || !name.substring(name.length() - 5).equals(".java")) {
            int index;
            Logger logger = JavaPlugin.getDefault().getLogger();
            if (logger.isLoggingLevel(Level.FINE)) {
                logger.log((Object)("Invalid .java file: " + name), Level.FINE);
            }
            name = (index = name.lastIndexOf(".")) >= 0 ? String.valueOf(name.substring(0, index)) + ".java" : String.valueOf(name) + ".java";
        }
        if (element.getParent().getElementName() == null || element.getParent().getElementName().length() == 0) {
            return name.substring(0, name.length() - 5);
        }
        return String.valueOf(element.getParent().getElementName()) + "." + name.substring(0, name.length() - 5);
    }

    public void stopSynchronizer() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void elementChanged(ElementChangedEvent event) {
        try {
            this.flushTypes.clear();
            this.flushTypePlusInner.clear();
            this.notifications.clear();
            super.elementChanged(event);
            this.flushTypes();
            this.processNotifications();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.flushedAll = false;
            this.flushTypes.clear();
            this.flushTypePlusInner.clear();
            this.notifications.clear();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.flushedAll = false;
            this.flushTypes.clear();
            this.flushTypePlusInner.clear();
            this.notifications.clear();
            return;
        }
    }

    private void flushTypes() {
        Notification not;
        int i;
        if (!this.flushTypes.isEmpty()) {
            IType type = null;
            i = 0;
            while (i < this.flushTypes.size()) {
                type = (IType)this.flushTypes.get(i);
                not = this.doFlush(type);
                if (not != null) {
                    this.notifications.add(not);
                }
                ++i;
            }
        }
        if (!this.flushTypePlusInner.isEmpty()) {
            ICompilationUnit unit = null;
            i = 0;
            while (i < this.flushTypePlusInner.size()) {
                unit = (ICompilationUnit)this.flushTypePlusInner.get(i);
                not = this.doFlush(unit);
                if (not != null) {
                    this.notifications.add(not);
                }
                ++i;
            }
        }
    }

    private void processNotifications() {
        int i = 0;
        while (i < this.notifications.size()) {
            Notification not = (Notification)this.notifications.get(i);
            Notifier notifier = (Notifier)not.getNotifier();
            if (notifier != null) {
                try {
                    notifier.eNotify(not);
                }
                catch (Exception e) {
                    JavaPlugin.getDefault().getLogger().log((Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void disAssociateSource(String qualifiedName) {
        Notification not = this.getAdapterFactory().disAssociateSource(qualifiedName, false);
        if (not != null) {
            this.notifications.add(not);
        }
    }

    protected void disAssociateSourcePlusInner(String qualifiedName) {
        Notification not = this.getAdapterFactory().disAssociateSourcePlusInner(qualifiedName, false);
        if (not != null) {
            this.notifications.add(not);
        }
    }

    protected void flushAll() {
        this.notifications.addAll(this.getAdapterFactory().flushAllNoNotification());
        this.flushedAll = true;
    }

    protected void processChildren(IJavaElement element, IJavaElementDelta delta) {
        if (!this.flushedAll) {
            super.processChildren(element, delta);
        }
    }

    public void processDelta(IJavaElementDelta delta) {
        if (!this.flushedAll) {
            super.processDelta(delta);
        }
    }
}

