/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.jpt.db.internal.ConnectionProfileHolder;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.utility.internal.StringTools;

abstract class DTPWrapper
implements ConnectionProfileHolder {
    private final ConnectionProfileHolder connectionProfileHolder;
    private final ICatalogObjectListener catalogObjectListener;
    private final boolean connectionIsLive;
    final ICatalogObject catalogObject;

    DTPWrapper(ConnectionProfileHolder connectionProfileHolder, Object dtpObject) {
        this.connectionProfileHolder = connectionProfileHolder;
        this.connectionIsLive = this.getConnectionProfile().isConnected();
        if (this.connectionIsLive) {
            this.catalogObject = (ICatalogObject)dtpObject;
            this.catalogObjectListener = this.buildCatalogObjectListener();
            RefreshManager.getInstance().AddListener(this.catalogObject, this.catalogObjectListener);
        } else {
            this.catalogObject = null;
            this.catalogObjectListener = null;
        }
    }

    private ICatalogObjectListener buildCatalogObjectListener() {
        return new ICatalogObjectListener(){

            public void notifyChanged(ICatalogObject dmElement, int eventType) {
                if (dmElement == DTPWrapper.this.catalogObject) {
                    DTPWrapper.this.catalogObjectChanged(eventType);
                }
            }
        };
    }

    abstract void catalogObjectChanged(int var1);

    public DTPConnectionProfileWrapper getConnectionProfile() {
        return this.connectionProfileHolder.getConnectionProfile();
    }

    void dispose() {
        if (this.connectionIsLive) {
            RefreshManager.getInstance().removeListener(this.catalogObject, this.catalogObjectListener);
        }
    }

    abstract String getName();

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }
}

