/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.ear;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jee.ui.internal.navigator.ear.AbstractEarNode;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class BundledNode
extends AbstractEarNode {
    private static final List<String> UTILITY = Collections.singletonList("jst.utility");
    private final String nodeName;
    private final BundledNode bundledLibsDirectoryNode;

    public BundledNode(IProject earProject, String nodeName, BundledNode bundledLibsDirectoryNode) {
        super(earProject);
        this.nodeName = nodeName;
        this.bundledLibsDirectoryNode = bundledLibsDirectoryNode;
        this.type = LIBS_TYPE;
    }

    public String toString() {
        return this.nodeName;
    }

    public String getText() {
        return this.nodeName;
    }

    public BundledNode getBundledLibsDirectoryNode() {
        return this.bundledLibsDirectoryNode;
    }

    public List getModules() {
        IVirtualComponent projectComponent = ComponentCore.createComponent((IProject)this.getEarProject());
        Path libPath = new Path("/");
        if (this.bundledLibsDirectoryNode == null) {
            libPath = new Path("/" + this.recomputeLibFolder(this.getEarProject()));
        }
        List libs = this.getComponentReferencesAsList(UTILITY, projectComponent, (IPath)libPath);
        libs.addAll(this.getBinariesInLibDir(projectComponent, (IPath)libPath, UTILITY));
        ArrayList modules = new ArrayList();
        int i = 0;
        while (i < libs.size()) {
            IVirtualReference reference = (IVirtualReference)libs.get(i);
            IPath runtimePath = this.getRealRuntimePath(reference);
            if (runtimePath != null && runtimePath.segment(0) != null && runtimePath.equals((Object)libPath)) {
                if (this.bundledLibsDirectoryNode == null) {
                    modules.add(libs.get(i));
                }
            } else if (this.bundledLibsDirectoryNode != null) {
                modules.add(libs.get(i));
            }
            ++i;
        }
        if (this.bundledLibsDirectoryNode != null) {
            modules.add(this.bundledLibsDirectoryNode);
        }
        return modules;
    }
}

