/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanScopeType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.jst.jsf.validation.internal.appconfig.EObjectValidationVisitor;
import org.eclipse.jst.jsf.validation.internal.appconfig.ManagedPropertyValidationVisitor;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ManagedBeanValidationVisitor
extends EObjectValidationVisitor {
    public ManagedBeanValidationVisitor(String version) {
        super((EStructuralFeature)FacesConfigPackage.eINSTANCE.getFacesConfigType_ManagedBean(), version);
    }

    protected void doValidate(EObject object, List messages, IFile file) {
        ManagedBeanType managedBean = (ManagedBeanType)object;
        this.validateScope(managedBean.getManagedBeanScope(), messages, file);
        this.validateClass(managedBean.getManagedBeanClass(), messages, file);
        this.validateEntryTypes(managedBean, messages, file);
    }

    private void validateScope(ManagedBeanScopeType scope, List messages, IFile file) {
        if (scope != null && scope.getTextContent() != null) {
            ManagedBeanValidationVisitor.addMessageInfo(messages, AppConfigValidationUtil.validateManagedBeanScope(scope), (EObject)scope, file);
        }
    }

    private void validateClass(ManagedBeanClassType classType, List messages, IFile file) {
        if (classType != null) {
            String classTypeValue = classType.getTextContent();
            ManagedBeanValidationVisitor.addMessageInfo(messages, AppConfigValidationUtil.validateClassName(classTypeValue == null ? "" : classTypeValue, null, true, file.getProject()), (EObject)classType, file);
        }
    }

    private void validateEntryTypes(ManagedBeanType managedBeanType, List messages, IFile file) {
        if (managedBeanType.getManagedBeanName() != null && managedBeanType.getManagedBeanClass() != null) {
            String propertyName = managedBeanType.getManagedBeanName().getTextContent();
            String propertyClass = managedBeanType.getManagedBeanClass().getTextContent();
            if (propertyName == null || propertyClass == null || "".equals(propertyName.trim()) || "".equals(propertyClass.trim())) {
                return;
            }
            IMessage message = null;
            MapEntriesType eObj = null;
            if (managedBeanType.getMapEntries() != null) {
                eObj = managedBeanType.getMapEntries();
                message = AppConfigValidationUtil.validateMapEntries(propertyName, propertyClass, eObj, file.getProject());
            } else if (managedBeanType.getListEntries() != null) {
                eObj = managedBeanType.getListEntries();
                message = AppConfigValidationUtil.validateListEntries(propertyName, propertyClass, (ListEntriesType)eObj, file.getProject());
            }
            ManagedBeanValidationVisitor.addMessageInfo(messages, message, (EObject)eObj, file);
        }
    }

    protected EObjectValidationVisitor[] getChildNodeValidators() {
        return new EObjectValidationVisitor[]{new ManagedPropertyValidationVisitor(this.getVersion())};
    }
}

