/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.commentelement.impl;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.commentelement.CommentElementHandler;
import org.eclipse.wst.xml.core.internal.commentelement.impl.CommentElementConfiguration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class CommentElementRegistry {
    private static CommentElementRegistry fInstance = null;
    private String EXTENSION_POINT_ID = "commentElementHandler";
    private CommentElementConfiguration[] fConfigurations = null;
    private String PLUGIN_ID = "org.eclipse.wst.sse.core";

    public static synchronized CommentElementRegistry getInstance() {
        if (fInstance == null) {
            fInstance = new CommentElementRegistry();
        }
        return fInstance;
    }

    private CommentElementRegistry() {
    }

    public CommentElementConfiguration[] getConfigurations() {
        if (this.fConfigurations == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(this.PLUGIN_ID, this.EXTENSION_POINT_ID);
            if (point != null) {
                IConfigurationElement[] elements = point.getConfigurationElements();
                this.fConfigurations = new CommentElementConfiguration[elements.length];
                int i = 0;
                while (i < elements.length) {
                    this.fConfigurations[i] = new CommentElementConfiguration(elements[i]);
                    ++i;
                }
            }
            if (this.fConfigurations == null) {
                this.fConfigurations = new CommentElementConfiguration[0];
            }
        }
        return this.fConfigurations;
    }

    public boolean setupCommentElement(IDOMElement element) {
        CommentElementConfiguration[] configurations = this.getConfigurations();
        int length = configurations.length;
        int i = 0;
        while (i < length) {
            CommentElementHandler handler;
            CommentElementConfiguration conf = configurations[i];
            boolean isJSP = element.isJSPTag();
            if ((isJSP && conf.acceptJSPComment() || !isJSP && conf.acceptXMLComment()) && (handler = conf.getHandler()).isCommentElement(element)) {
                conf.setupCommentElement(element);
                return true;
            }
            ++i;
        }
        return false;
    }
}

