/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.core.internal.util;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;

public class JavaeeResourceImpl
extends XMLResourceImpl {
    public JavaeeResourceImpl(URI uri) {
        super(uri);
    }

    public void save(Map options) throws IOException {
        IFile file = this.getPlatformFile();
        if (file == null || !file.exists()) {
            return;
        }
        super.save(options);
    }

    private IFile getPlatformFile(URI uri) {
        if (WorkbenchResourceHelperBase.isPlatformResourceURI((URI)uri)) {
            String fileString = URI.decode((String)uri.path());
            fileString = fileString.substring("resource".length() + 1);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileString));
        }
        return null;
    }

    private IFile getPlatformFile() {
        URIConverter converter;
        URI convertedUri;
        IFile file = null;
        file = this.getPlatformFile(this.getURI());
        if (file == null && this.getResourceSet() != null && !this.uri.equals((Object)(convertedUri = (converter = this.getResourceSet().getURIConverter()).normalize(this.uri)))) {
            file = this.getPlatformFile(convertedUri);
        }
        return file;
    }

    public void save(Map options, boolean force) throws IOException {
        IFile file = this.getPlatformFile();
        if (!(force || file != null && file.exists())) {
            return;
        }
        super.save(options);
        if (force) {
            this.getResourceSet().getResources().remove((Object)this);
        }
    }
}

