/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.IValidateEditContext;

public class CreateReferenceComponentsOp
extends AbstractDataModelOperation {
    public CreateReferenceComponentsOp(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.validateEdit().isOK()) {
            return Status.CANCEL_STATUS;
        }
        this.addReferencedComponents(monitor);
        this.addProjectReferences();
        return OK_STATUS;
    }

    protected IStatus validateEdit() {
        IStatus status = OK_STATUS;
        IValidateEditContext validator = (IValidateEditContext)UIContextDetermination.createInstance((String)"ValidateEditContext");
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        IProject project = sourceComp.getProject();
        if (status.isOK()) {
            StructureEdit sEdit = null;
            try {
                sEdit = StructureEdit.getStructureEditForWrite(project);
                status = validator.validateState((EditModel)sEdit.getModuleStructuralModel());
            }
            finally {
                if (sEdit != null) {
                    sEdit.dispose();
                }
            }
        }
        IFile[] files = new IFile[]{project.getFile(".project")};
        status = ResourcesPlugin.getWorkspace().validateEdit(files, null);
        return status;
    }

    protected void addProjectReferences() {
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        List modList = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        ArrayList<IProject> targetprojectList = new ArrayList<IProject>();
        int i = 0;
        while (i < modList.size()) {
            IVirtualComponent IVirtualComponent2 = (IVirtualComponent)modList.get(i);
            IProject targetProject = IVirtualComponent2.getProject();
            targetprojectList.add(targetProject);
            ++i;
        }
        try {
            ProjectUtilities.addReferenceProjects((IProject)sourceComp.getProject(), targetprojectList);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void addReferencedComponents(IProgressMonitor monitor) {
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        ArrayList<IVirtualReference> vlist = new ArrayList<IVirtualReference>();
        List modList = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        Map modDeployPathMap = (Map)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH_MAP");
        String deployPathStr = this.model.getStringProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH");
        Path deployPath = null;
        Path archiveDeployPath = null;
        if (deployPathStr != null && deployPathStr.length() > 0) {
            deployPath = new Path(deployPathStr);
        }
        int i = 0;
        while (i < modList.size()) {
            IVirtualComponent comp = (IVirtualComponent)modList.get(i);
            if (!this.srcComponentContainsReference(sourceComp, comp, (IPath)deployPath)) {
                String archiveName;
                IVirtualReference ref = ComponentCore.createReference(sourceComp, comp);
                deployPathStr = (String)modDeployPathMap.get(comp);
                archiveDeployPath = deployPathStr != null ? new Path(deployPathStr) : deployPath;
                if (archiveDeployPath != null) {
                    ref.setRuntimePath((IPath)archiveDeployPath);
                }
                if ((archiveName = this.getArchiveName(comp)).length() > 0) {
                    ref.setArchiveName(archiveName);
                }
                vlist.add(ref);
            }
            ++i;
        }
        IVirtualReference[] refs = vlist.toArray(new IVirtualReference[vlist.size()]);
        sourceComp.addReferences(refs);
    }

    protected String getArchiveName(IVirtualComponent comp) {
        Map map = (Map)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP");
        String uri = (String)map.get(comp);
        return uri == null ? "" : uri;
    }

    private boolean srcComponentContainsReference(IVirtualComponent sourceComp, IVirtualComponent comp, IPath deployPath) {
        if (sourceComp != null && sourceComp.getProject() != null && comp != null && comp.getProject() != null) {
            IVirtualReference[] existingReferences = sourceComp.getReferences();
            IVirtualComponent referencedComponent = null;
            if (existingReferences != null) {
                int i = 0;
                while (i < existingReferences.length) {
                    IVirtualReference ref = existingReferences[i];
                    if (ref != null && (ref.getRuntimePath() == null && deployPath != null || ref.getRuntimePath().equals((Object)deployPath)) && (referencedComponent = ref.getReferencedComponent()) != null && referencedComponent.equals(comp)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

