/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.ILog;
import org.eclipse.wst.server.core.IServer;

public abstract class AbstractStartServer {
    protected IProgressMonitor monitor;
    private ILog log_ = EnvironmentService.getEclipseLog();

    public void StartServer(IProject project, IServer server, IProgressMonitor monitor, boolean restart) throws CoreException {
        this.monitor = monitor;
        try {
            this.validateRemoteServerPath(server);
            if (server.getServerState() != 4) {
                if (server.getServerRestartState()) {
                    server.synchronousStop(false);
                    this.log_.log(1, 5050, (Object)this, "StartServer", (Object)("project=" + project + ", Stop command completed, restart needed"));
                    this.publishProject(server);
                    this.startProject(server);
                } else if (restart) {
                    this.publishProject(server);
                    this.restartProject(project, server);
                }
            } else {
                this.publishProject(server);
                this.startProject(server);
            }
        }
        catch (CoreException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.ws.consumption", 0, ConsumptionMessages.MSG_ERROR_SERVER, (Throwable)e));
        }
    }

    protected void publishProject(IServer server) throws CoreException {
        this.monitor.subTask(ConsumptionMessages.PROGRESS_INFO_PUBLISHING_SERVER);
        IStatus status = server.publish(1, this.monitor);
        if (status.getSeverity() != 0) {
            throw new CoreException(status);
        }
        this.log_.log(1, 5051, (Object)this, "publishProject", (Object)("IServer=" + server + ", Publish command completed"));
    }

    protected void startProject(IServer server) throws CoreException {
        try {
            this.monitor.subTask(ConsumptionMessages.PROGRESS_INFO_STARTING_SERVER);
            server.synchronousStart("run", this.monitor);
            this.log_.log(1, 5052, (Object)this, "startProject", (Object)("IServer=" + server + ", Start command completed"));
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.ws.consumption", 0, ConsumptionMessages.MSG_ERROR_SERVER, (Throwable)e));
        }
    }

    protected void restartProject(IProject project, IServer server) throws CoreException {
    }

    public void runPreServerConfig(IServer server, IProject EARProject) {
    }

    public void runPostServerConfig(IServer server, IProject EARProject) {
    }

    protected abstract void addJarsToClassPath(IServer var1) throws CoreException;

    protected abstract void validateRemoteServerPath(IServer var1) throws CoreException;

    public void stopServer(IServer server) throws CoreException {
        if (server != null && server.getServerState() != 4) {
            server.synchronousStop(false);
        }
    }
}

